/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.lib;

import codechicken.lib.gui.modular.lib.geometry.Borders;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import java.util.function.Supplier;
import net.covers1624.quack.annotation.ReplaceWithExpr;

public class Constraints {
    public static void bind(ConstrainedGeometry<?> element, ConstrainedGeometry<?> reference) {
        Constraints.bind(element, reference, 0.0);
    }

    public static void bind(ConstrainedGeometry<?> element, ConstrainedGeometry<?> reference, double borders) {
        Constraints.bind(element, reference, borders, borders, borders, borders);
    }

    public static void bind(ConstrainedGeometry<?> element, ConstrainedGeometry<?> reference, double top, double left, double bottom, double right) {
        element.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.TOP), top));
        element.constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.LEFT), left));
        element.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.BOTTOM), -bottom));
        element.constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.RIGHT), -right));
    }

    public static void bind(ConstrainedGeometry<?> element, ConstrainedGeometry<?> reference, Borders borders) {
        element.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.TOP), borders::top));
        element.constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.LEFT), borders::left));
        element.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.BOTTOM), () -> -borders.bottom()));
        element.constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.RIGHT), () -> -borders.right()));
    }

    public static void size(ConstrainedGeometry<?> element, double width, double height) {
        element.constrain(GeoParam.WIDTH, Constraint.literal(width));
        element.constrain(GeoParam.HEIGHT, Constraint.literal(height));
    }

    public static void size(ConstrainedGeometry<?> element, Supplier<Double> width, Supplier<Double> height) {
        element.constrain(GeoParam.WIDTH, Constraint.dynamic(width));
        element.constrain(GeoParam.HEIGHT, Constraint.dynamic(height));
    }

    public static void pos(ConstrainedGeometry<?> element, double left, double top) {
        element.constrain(GeoParam.LEFT, Constraint.literal(left));
        element.constrain(GeoParam.TOP, Constraint.literal(top));
    }

    public static void pos(ConstrainedGeometry<?> element, Supplier<Double> left, Supplier<Double> top) {
        element.constrain(GeoParam.LEFT, Constraint.dynamic(left));
        element.constrain(GeoParam.TOP, Constraint.dynamic(top));
    }

    public static void center(ConstrainedGeometry<?> element, ConstrainedGeometry<?> centerOn) {
        element.constrain(GeoParam.TOP, Constraint.midPoint(centerOn.get(GeoParam.TOP), centerOn.get(GeoParam.BOTTOM), () -> element.ySize() / -2.0));
        element.constrain(GeoParam.LEFT, Constraint.midPoint(centerOn.get(GeoParam.LEFT), centerOn.get(GeoParam.RIGHT), () -> element.xSize() / -2.0));
    }

    public static void center(ConstrainedGeometry<?> element, ConstrainedGeometry<?> centerOn, double xOffset, double yOffset) {
        element.constrain(GeoParam.TOP, Constraint.midPoint(centerOn.get(GeoParam.TOP), centerOn.get(GeoParam.BOTTOM), () -> element.ySize() / -2.0 + yOffset));
        element.constrain(GeoParam.LEFT, Constraint.midPoint(centerOn.get(GeoParam.LEFT), centerOn.get(GeoParam.RIGHT), () -> element.xSize() / -2.0 + xOffset));
    }

    @Deprecated
    @ReplaceWithExpr(value="target.placeInside")
    public static void placeInside(ConstrainedGeometry<?> target, ConstrainedGeometry<?> reference, LayoutPos position) {
        target.placeInside(reference, position);
    }

    @Deprecated
    @ReplaceWithExpr(value="target.placeInside")
    public static void placeInside(ConstrainedGeometry<?> target, ConstrainedGeometry<?> reference, LayoutPos position, double xOffset, double yOffset) {
        target.placeInside(reference, position, xOffset, yOffset);
    }

    @Deprecated
    @ReplaceWithExpr(value="target.placeOutside")
    public static void placeOutside(ConstrainedGeometry<?> target, ConstrainedGeometry<?> reference, LayoutPos position) {
        target.placeOutside(reference, position);
    }

    @Deprecated
    @ReplaceWithExpr(value="target.placeOutside")
    public static void placeOutside(ConstrainedGeometry<?> target, ConstrainedGeometry<?> reference, LayoutPos position, double xOffset, double yOffset) {
        target.placeOutside(reference, position, xOffset, yOffset);
    }

    public static enum LayoutPos {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        MIDDLE_RIGHT,
        MIDDLE_LEFT,
        BOTTOM_RIGHT,
        BOTTOM_CENTER,
        BOTTOM_LEFT;

    }
}

