/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.TextState;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiTextField
extends GuiElement<GuiTextField>
implements BackgroundRender {
    private static final RenderType HIGHLIGHT_TYPE = RenderType.create((String)"text_field_highlight", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorShader)).setColorLogicState(RenderStateShard.OR_REVERSE_COLOR_LOGIC).createCompositeState(false));
    private int tick;
    private int cursorPos;
    private int maxLength = 32;
    private int displayPos;
    private int highlightPos;
    private boolean focused;
    private boolean shiftPressed;
    private Supplier<Boolean> isEditable = () -> true;
    private Supplier<Boolean> isFocusable = () -> true;
    private Supplier<Boolean> canLoseFocus = () -> true;
    private Runnable onEditComplete = null;
    private Runnable onEnterPressed = null;
    private TextState textState = TextState.simpleState("");
    private Supplier<Boolean> shadow = () -> true;
    private Supplier<Integer> textColor = () -> 0xE0E0E0;
    private Supplier<Component> suggestion = null;
    private Supplier<Integer> suggestionColour = () -> 8355712;
    private Supplier<Boolean> suggestionShadow = () -> true;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, FormattedCharSequence> formatter = (string, pos) -> FormattedCharSequence.forward((String)string, (Style)Style.EMPTY);

    public GuiTextField(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public static TextField create(GuiElement<?> parent, int backgroundColour, int borderColour, int textColour) {
        GuiRectangle background = new GuiRectangle(parent).rectangle(backgroundColour, borderColour);
        GuiTextField textField = (GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)new GuiTextField(background).setTextColor(textColour).constrain(GeoParam.TOP, Constraint.relative(background.get(GeoParam.TOP), 1.0))).constrain(GeoParam.BOTTOM, Constraint.relative(background.get(GeoParam.BOTTOM), -1.0))).constrain(GeoParam.LEFT, Constraint.relative(background.get(GeoParam.LEFT), 4.0))).constrain(GeoParam.RIGHT, Constraint.relative(background.get(GeoParam.RIGHT), -4.0));
        return new TextField(background, textField);
    }

    public GuiTextField setOnEditComplete(Runnable onEditComplete) {
        this.onEditComplete = onEditComplete;
        return this;
    }

    public GuiTextField setEnterPressed(Runnable onEnterPressed) {
        this.onEnterPressed = onEnterPressed;
        return this;
    }

    public GuiTextField setTextState(TextState textState) {
        this.textState = textState;
        return this;
    }

    public TextState getTextState() {
        return this.textState;
    }

    public GuiTextField setTextColor(Supplier<Integer> textColor) {
        this.textColor = textColor;
        return this;
    }

    public GuiTextField setTextColor(int textColor) {
        return this.setTextColor(() -> textColor);
    }

    public GuiTextField setShadow(Supplier<Boolean> shadow) {
        this.shadow = shadow;
        return this;
    }

    public GuiTextField setShadow(boolean shadow) {
        return this.setShadow(() -> shadow);
    }

    public GuiTextField setSuggestion(Component suggestion) {
        return this.setSuggestion(suggestion == null ? null : () -> suggestion);
    }

    public GuiTextField setSuggestion(@Nullable Supplier<Component> suggestion) {
        this.suggestion = suggestion;
        return this;
    }

    public GuiTextField setSuggestionColour(Supplier<Integer> suggestionColour) {
        this.suggestionColour = suggestionColour;
        return this;
    }

    public GuiTextField setSuggestionColour(int suggestionColour) {
        this.suggestionColour = () -> suggestionColour;
        return this;
    }

    public GuiTextField setSuggestionShadow(Supplier<Boolean> suggestionShadow) {
        this.suggestionShadow = suggestionShadow;
        return this;
    }

    public GuiTextField setSuggestionShadow(boolean suggestionShadow) {
        this.suggestionShadow = () -> suggestionShadow;
        return this;
    }

    public GuiTextField setFilter(Predicate<String> filter) {
        this.filter = filter;
        return this;
    }

    public GuiTextField setFormatter(BiFunction<String, Integer, FormattedCharSequence> formatter) {
        this.formatter = formatter;
        return this;
    }

    public GuiTextField setCanLoseFocus(boolean canLoseFocus) {
        return this.setCanLoseFocus(() -> canLoseFocus);
    }

    public GuiTextField setCanLoseFocus(Supplier<Boolean> canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
        return this;
    }

    public GuiTextField setFocusable(boolean focusable) {
        return this.setFocusable(() -> focusable);
    }

    public GuiTextField setFocusable(Supplier<Boolean> focusable) {
        this.isFocusable = focusable;
        return this;
    }

    public GuiTextField setEditable(boolean editable) {
        return this.setEditable(() -> editable);
    }

    public GuiTextField setEditable(Supplier<Boolean> editable) {
        this.isEditable = editable;
        return this;
    }

    public GuiTextField setMaxLength(int newWidth) {
        String value = this.getValue();
        this.maxLength = newWidth;
        if (value.length() > newWidth) {
            this.textState.setText(value.substring(0, newWidth));
        }
        return this;
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public GuiTextField setValue(String newValue) {
        if (this.filter.test(newValue)) {
            if (newValue.length() > this.maxLength) {
                this.textState.setText(newValue.substring(0, this.maxLength));
            } else {
                this.textState.setText(newValue);
            }
            this.moveCursorToEnd();
            this.setHighlightPos(this.cursorPos);
        }
        return this;
    }

    public String getValue() {
        return this.textState.getText();
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.getValue().substring(i, j);
    }

    public void insertText(String text) {
        String newValue;
        String toInsert;
        int insertLen;
        String value = this.getValue();
        int selectStart = Math.min(this.cursorPos, this.highlightPos);
        int selectEnd = Math.max(this.cursorPos, this.highlightPos);
        int freeSpace = this.maxLength - value.length() - (selectStart - selectEnd);
        if (freeSpace < (insertLen = (toInsert = StringUtil.filterText((String)text)).length())) {
            toInsert = toInsert.substring(0, freeSpace);
            insertLen = freeSpace;
        }
        if (this.filter.test(newValue = new StringBuilder(value).replace(selectStart, selectEnd, toInsert).toString())) {
            this.textState.setText(newValue);
            this.setCursorPosition(selectStart + insertLen);
            this.setHighlightPos(this.cursorPos);
        }
    }

    private void deleteText(int i) {
        if (Screen.hasControlDown()) {
            this.deleteWords(i);
        } else {
            this.deleteChars(i);
        }
    }

    public void deleteWords(int i) {
        if (!this.getValue().isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteChars(this.getWordPosition(i) - this.cursorPos);
            }
        }
    }

    public void deleteChars(int i1) {
        String value = this.getValue();
        if (!value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                String s;
                int k;
                int i = this.getCursorPos(i1);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos)) && this.filter.test(s = new StringBuilder(value).delete(j, k).toString())) {
                    this.textState.setText(s);
                    this.moveCursorTo(j);
                }
            }
        }
    }

    public int getWordPosition(int i) {
        return this.getWordPosition(i, this.getCursorPosition());
    }

    private int getWordPosition(int i, int i1) {
        return this.getWordPosition(i, i1, true);
    }

    private int getWordPosition(int i1, int i2, boolean b) {
        String value = this.getValue();
        int i = i2;
        boolean flag = i1 < 0;
        int j = Math.abs(i1);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = value.length();
                if ((i = value.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (b && i < l && value.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (b && i > 0 && value.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && value.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int pos) {
        this.moveCursorTo(this.getCursorPos(pos));
    }

    private int getCursorPos(int i) {
        return Util.offsetByCodepoints((String)this.getValue(), (int)this.cursorPos, (int)i);
    }

    public void moveCursorTo(int pos, boolean notify) {
        this.setCursorPosition(pos);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPos);
        }
    }

    public void moveCursorTo(int pos) {
        this.moveCursorTo(pos, true);
    }

    public void setCursorPosition(int pos) {
        this.cursorPos = Mth.clamp((int)pos, (int)0, (int)this.getValue().length());
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd(boolean notify) {
        this.moveCursorTo(this.getValue().length(), notify);
    }

    public void moveCursorToEnd() {
        this.moveCursorToEnd(true);
    }

    public boolean isEditable() {
        return this.isEditable.get();
    }

    public void setFocus(boolean focused) {
        if (this.focused && !focused && this.onEditComplete != null) {
            this.onEditComplete.run();
        }
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public void setHighlightPos(int newPos) {
        String value = this.getValue();
        int length = value.length();
        this.highlightPos = Mth.clamp((int)newPos, (int)0, (int)length);
        if (this.displayPos > length) {
            this.displayPos = length;
        }
        int width = (int)this.xSize();
        String visibleText = this.font().plainSubstrByWidth(value.substring(this.displayPos), width);
        int endPos = this.displayPos + visibleText.length();
        if (this.highlightPos == this.displayPos) {
            this.displayPos -= this.font().plainSubstrByWidth(value, width, true).length();
        }
        if (this.highlightPos > endPos) {
            this.displayPos += this.highlightPos - endPos;
        } else if (this.highlightPos <= this.displayPos) {
            this.displayPos -= this.displayPos - this.highlightPos;
        }
        this.displayPos = Mth.clamp((int)this.displayPos, (int)0, (int)length);
    }

    @Override
    public boolean keyPressed(int key, int scancode, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = Screen.hasShiftDown();
        if (Screen.isSelectAll((int)key)) {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            return true;
        }
        if (Screen.isCopy((int)key)) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getHighlighted());
            return true;
        }
        if (Screen.isPaste((int)key)) {
            if (this.isEditable()) {
                this.insertText(Minecraft.getInstance().keyboardHandler.getClipboard());
            }
            return true;
        }
        if (Screen.isCut((int)key)) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getHighlighted());
            if (this.isEditable()) {
                this.insertText("");
            }
            return true;
        }
        switch (key) {
            case 259: {
                if (this.isEditable()) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = Screen.hasShiftDown();
                }
                return true;
            }
            case 257: 
            case 335: {
                if (this.onEditComplete != null) {
                    this.onEditComplete.run();
                }
                if (this.onEnterPressed != null) {
                    this.onEnterPressed.run();
                }
            }
            default: {
                return key != 256;
            }
            case 261: {
                if (this.isEditable()) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = Screen.hasShiftDown();
                }
                return true;
            }
            case 262: {
                if (Screen.hasControlDown()) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (Screen.hasControlDown()) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart();
                return true;
            }
            case 269: 
        }
        this.moveCursorToEnd();
        return true;
    }

    public boolean canConsumeInput() {
        return this.isFocused() && this.isEditable() && this.isEnabled();
    }

    @Override
    public boolean keyReleased(int key, int scancode, int modifiers, boolean consumed) {
        this.shiftPressed = Screen.hasShiftDown();
        return super.keyReleased(key, scancode, modifiers, consumed);
    }

    @Override
    public boolean charTyped(char charTyped, int charCode) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (StringUtil.isAllowedChatCharacter((char)charTyped)) {
            if (this.isEditable()) {
                this.insertText(Character.toString(charTyped));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button, boolean consumed) {
        consumed = super.mouseClicked(mouseX, mouseY, button, consumed);
        boolean mouseOver = this.isMouseOver();
        if (this.isFocused() && !mouseOver) {
            this.setFocus(this.isFocusable.get() != false && this.canLoseFocus.get() == false);
        }
        if (consumed) {
            return true;
        }
        if (this.canLoseFocus.get().booleanValue()) {
            this.setFocus(mouseOver && this.isFocusable.get() != false);
        } else {
            this.setFocus(this.isFocusable.get());
        }
        if (this.isFocused() && mouseOver && button == 0) {
            int i = (int)((double)Mth.floor((double)mouseX) - this.xMin());
            String s = this.font().plainSubstrByWidth(this.getValue().substring(this.displayPos), (int)this.xSize());
            this.moveCursorTo(this.font().plainSubstrByWidth(s, i).length() + this.displayPos);
            return true;
        }
        return false;
    }

    @Override
    public double getBackgroundDepth() {
        return 0.04;
    }

    @Override
    public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        String value = this.getValue();
        int colour = this.textColor.get();
        int textStart = this.cursorPos - this.displayPos;
        int highlightStart = this.highlightPos - this.displayPos;
        String displayText = this.font().plainSubstrByWidth(value.substring(this.displayPos), (int)this.xSize());
        boolean flag = textStart >= 0 && textStart <= displayText.length();
        boolean cursorBlink = this.isFocused() && this.tick / 6 % 2 == 0 && flag;
        double drawX = this.xMin();
        double drawY = this.yMin() + (this.ySize() - 8.0) / 2.0;
        int drawEnd = (int)drawX;
        if (highlightStart > displayText.length()) {
            highlightStart = displayText.length();
        }
        if (!displayText.isEmpty()) {
            String drawString = flag ? displayText.substring(0, textStart) : displayText;
            drawEnd = render.drawString(this.formatter.apply(drawString, this.displayPos), drawX, drawY, colour, (boolean)this.shadow.get());
        }
        boolean flag2 = this.cursorPos < value.length() || value.length() >= this.getMaxLength();
        int k1 = drawEnd;
        if (!flag) {
            k1 = (int)(textStart > 0 ? drawX + this.xSize() : drawX);
        } else if (flag2) {
            k1 = drawEnd - 1;
            --drawEnd;
        }
        if (!displayText.isEmpty() && flag && textStart < displayText.length()) {
            render.drawString(this.formatter.apply(displayText.substring(textStart), this.cursorPos), (double)drawEnd, drawY, colour, (boolean)this.shadow.get());
        }
        if (this.suggestion != null && value.isEmpty()) {
            render.drawString(this.suggestion.get(), (double)(k1 - 1), (double)((float)drawY), (int)this.suggestionColour.get(), (boolean)this.suggestionShadow.get());
        }
        if (cursorBlink) {
            if (flag2) {
                render.fill(k1, drawY - 1.0, k1 + 1, drawY + 1.0 + 9.0, -3092272);
            } else {
                render.drawString("_", (double)k1, (double)((float)drawY), colour, (boolean)this.shadow.get());
            }
        }
        if (highlightStart != textStart) {
            int l1 = (int)(drawX + (double)this.font().width(displayText.substring(0, highlightStart)));
            render.pose().translate(0.0, 0.0, 0.035);
            render.fill(HIGHLIGHT_TYPE, k1, drawY - 1.0, l1 - 1, drawY + 1.0 + 9.0, -16776961);
            render.pose().translate(0.0, 0.0, -0.035);
        }
    }

    @Override
    public void tick(double mouseX, double mouseY) {
        super.tick(mouseX, mouseY);
        ++this.tick;
    }

    public record TextField(GuiRectangle container, GuiTextField field) {
    }
}

