/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class GuiEventProvider
extends GuiElement<GuiEventProvider> {
    private boolean ignoreConsumed = false;
    private final List<TriConsumer<Double, Double, Integer>> clickListeners = new ArrayList<TriConsumer<Double, Double, Integer>>();
    private final List<TriConsumer<Double, Double, Integer>> releaseListeners = new ArrayList<TriConsumer<Double, Double, Integer>>();
    private final List<BiConsumer<Double, Double>> movedListeners = new ArrayList<BiConsumer<Double, Double>>();
    private final List<ScrollListener> scrollListeners = new ArrayList<ScrollListener>();
    private final List<TriConsumer<Integer, Integer, Integer>> keyPressListeners = new ArrayList<TriConsumer<Integer, Integer, Integer>>();
    private final List<TriConsumer<Integer, Integer, Integer>> keyReleaseListeners = new ArrayList<TriConsumer<Integer, Integer, Integer>>();
    private final List<BiConsumer<Character, Integer>> charTypedListeners = new ArrayList<BiConsumer<Character, Integer>>();

    public GuiEventProvider(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public GuiEventProvider setIgnoreConsumed(boolean ignoreConsumed) {
        this.ignoreConsumed = ignoreConsumed;
        return this;
    }

    public GuiEventProvider onMouseClick(TriConsumer<Double, Double, Integer> listener) {
        this.clickListeners.add(listener);
        return this;
    }

    public GuiEventProvider onMouseRelease(TriConsumer<Double, Double, Integer> listener) {
        this.releaseListeners.add(listener);
        return this;
    }

    public GuiEventProvider onMouseMove(BiConsumer<Double, Double> listener) {
        this.movedListeners.add(listener);
        return this;
    }

    public GuiEventProvider onScroll(ScrollListener listener) {
        this.scrollListeners.add(listener);
        return this;
    }

    public GuiEventProvider onKeyPress(TriConsumer<Integer, Integer, Integer> listener) {
        this.keyPressListeners.add(listener);
        return this;
    }

    public GuiEventProvider onKeyRelease(TriConsumer<Integer, Integer, Integer> listener) {
        this.keyReleaseListeners.add(listener);
        return this;
    }

    public GuiEventProvider onCharTyped(BiConsumer<Character, Integer> listener) {
        this.charTypedListeners.add(listener);
        return this;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button, boolean consumed) {
        if (this.ignoreConsumed || !consumed) {
            this.clickListeners.forEach(e -> e.accept((Object)mouseX, (Object)mouseY, (Object)button));
        }
        return super.mouseClicked(mouseX, mouseY, button, consumed);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button, boolean consumed) {
        if (this.ignoreConsumed || !consumed) {
            this.releaseListeners.forEach(e -> e.accept((Object)mouseX, (Object)mouseY, (Object)button));
        }
        return super.mouseReleased(mouseX, mouseY, button, consumed);
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        this.movedListeners.forEach(e -> e.accept(mouseX, mouseY));
        super.mouseMoved(mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, boolean consumed) {
        if (this.ignoreConsumed || !consumed) {
            this.scrollListeners.forEach(e -> e.onScrolled(mouseX, mouseY, scrollX, scrollY));
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY, consumed);
    }

    @Override
    public boolean keyPressed(int key, int scancode, int modifiers, boolean consumed) {
        if (this.ignoreConsumed || !consumed) {
            this.keyPressListeners.forEach(e -> e.accept((Object)key, (Object)scancode, (Object)modifiers));
        }
        return super.keyPressed(key, scancode, modifiers, consumed);
    }

    @Override
    public boolean keyReleased(int key, int scancode, int modifiers, boolean consumed) {
        if (this.ignoreConsumed || !consumed) {
            this.keyReleaseListeners.forEach(e -> e.accept((Object)key, (Object)scancode, (Object)modifiers));
        }
        return super.keyReleased(key, scancode, modifiers, consumed);
    }

    @Override
    public boolean charTyped(char character, int modifiers, boolean consumed) {
        if (this.ignoreConsumed || !consumed) {
            this.charTypedListeners.forEach(e -> e.accept(Character.valueOf(character), modifiers));
        }
        return super.charTyped(character, modifiers, consumed);
    }

    public static interface ScrollListener {
        public void onScrolled(double var1, double var3, double var5, double var7);
    }
}

