/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.elements.GuiTexture;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.sprite.GuiTextures;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiButton
extends GuiElement<GuiButton> {
    public static final int LEFT_CLICK = 0;
    public static final int RIGHT_CLICK = 1;
    public static final int MIDDLE_CLICK = 2;
    private final Map<Integer, Runnable> onClick = new HashMap<Integer, Runnable>();
    private final Map<Integer, Runnable> onPress = new HashMap<Integer, Runnable>();
    private boolean pressed = false;
    private Holder<SoundEvent> pressSound = SoundEvents.UI_BUTTON_CLICK;
    private Holder<SoundEvent> releaseSound = null;
    private Supplier<Boolean> disabled = () -> false;
    private Supplier<Boolean> toggleState;
    private GuiText label = null;
    private boolean resetHoverOnPress = true;

    public GuiButton(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public static GuiButton vanilla(@NotNull GuiParent<?> parent, @Nullable Component label, Runnable onClick) {
        return GuiButton.vanilla(parent, label).onClick(onClick);
    }

    public static GuiButton vanilla(@NotNull GuiParent<?> parent, @Nullable Component label) {
        GuiButton button = new GuiButton(parent);
        GuiTexture texture = new GuiTexture(button, GuiTextures.CCL.getter(() -> button.toggleState() ? "dynamic/button_highlight" : "dynamic/button_vanilla"));
        texture.dynamicTexture();
        GuiRectangle highlight = new GuiRectangle(button).border(() -> button.hoverTime() > 0 ? -1 : 0);
        Constraints.bind(texture, button);
        Constraints.bind(highlight, button);
        if (label != null) {
            button.setLabel(new GuiText(button, label));
            Constraints.bind(button.getLabel(), button, 0.0, 2.0, 0.0, 2.0);
        }
        return button;
    }

    public static GuiButton vanillaAnimated(@NotNull GuiParent<?> parent, Component label, Runnable onPress) {
        return GuiButton.vanillaAnimated(parent, label == null ? null : () -> label, onPress);
    }

    public static GuiButton vanillaAnimated(@NotNull GuiParent<?> parent, @Nullable Supplier<Component> label, Runnable onPress) {
        return GuiButton.vanillaAnimated(parent, label).onPress(onPress);
    }

    public static GuiButton vanillaAnimated(@NotNull GuiParent<?> parent, Component label) {
        return GuiButton.vanillaAnimated(parent, label == null ? null : () -> label);
    }

    public static GuiButton vanillaAnimated(@NotNull GuiParent<?> parent, @Nullable Supplier<Component> label) {
        GuiButton button = new GuiButton(parent);
        GuiTexture texture = new GuiTexture(button, GuiTextures.CCL.getter(() -> button.toggleState() || button.isPressed() ? "dynamic/button_pressed" : "dynamic/button_vanilla"));
        texture.dynamicTexture();
        GuiRectangle highlight = new GuiRectangle(button).border(() -> button.isMouseOver() ? -1 : 0);
        Constraints.bind(texture, button);
        Constraints.bind(highlight, button);
        if (label != null) {
            button.setLabel((GuiText)((GuiText)((GuiText)((GuiText)new GuiText(button, label).constrain(GeoParam.TOP, (Constraint)Constraint.relative(button.get(GeoParam.TOP), () -> button.isPressed() ? -0.5 : 0.5).precise())).constrain(GeoParam.LEFT, (Constraint)Constraint.relative(button.get(GeoParam.LEFT), () -> button.isPressed() ? 1.5 : 2.5).precise())).constrain(GeoParam.WIDTH, Constraint.relative(button.get(GeoParam.WIDTH), -4.0))).constrain(GeoParam.HEIGHT, Constraint.match(button.get(GeoParam.HEIGHT))));
        }
        return button;
    }

    public static GuiButton flatColourButton(@NotNull GuiParent<?> parent, @Nullable Supplier<Component> label, Function<Boolean, Integer> buttonColour) {
        return GuiButton.flatColourButton(parent, label, buttonColour, null);
    }

    public static GuiButton flatColourButton(@NotNull GuiParent<?> parent, @Nullable Supplier<Component> label, Function<Boolean, Integer> buttonColour, @Nullable Function<Boolean, Integer> borderColour) {
        GuiButton button = new GuiButton(parent);
        GuiRectangle background = new GuiRectangle(button).fill(() -> (Integer)buttonColour.apply(button.isMouseOver() || button.toggleState() || button.isPressed())).border(borderColour == null ? null : () -> (Integer)borderColour.apply(button.isMouseOver() || button.toggleState() || button.isPressed()));
        Constraints.bind(background, button);
        if (label != null) {
            GuiText text = new GuiText(button, label);
            button.setLabel(text);
            Constraints.bind(text, button, 0.0, 2.0, 0.0, 2.0);
        }
        return button;
    }

    public GuiButton setLabel(GuiText label) {
        this.label = label;
        return this;
    }

    public GuiText getLabel() {
        return this.label;
    }

    public GuiButton setResetHoverOnPress(boolean resetHoverOnPress) {
        this.resetHoverOnPress = resetHoverOnPress;
        return this;
    }

    public GuiButton onClick(Runnable onClick) {
        return this.onClick(onClick, 0);
    }

    public GuiButton onClick(Runnable onClick, int mouseButton) {
        this.onClick.put(mouseButton, onClick);
        return this;
    }

    public GuiButton onPress(Runnable onPress) {
        return this.onPress(onPress, 0);
    }

    public GuiButton onPress(Runnable onPress, int mouseButton) {
        this.onPress.put(mouseButton, onPress);
        return this;
    }

    public GuiButton setDisabled(boolean disabled) {
        this.disabled = () -> disabled;
        return this;
    }

    public GuiButton setDisabled(Supplier<Boolean> disabled) {
        this.disabled = disabled;
        return this;
    }

    public GuiButton setToggleMode(@Nullable Supplier<Boolean> toggleState) {
        this.toggleState = toggleState;
        return this;
    }

    public boolean isDisabled() {
        return this.disabled.get();
    }

    public boolean isPressed() {
        return this.pressed && this.hoverTime() > 0;
    }

    public boolean toggleState() {
        return this.toggleState != null && this.toggleState.get() != false;
    }

    public GuiButton setPressSound(Holder<SoundEvent> pressSound) {
        this.pressSound = pressSound;
        return this;
    }

    public GuiButton setReleaseSound(Holder<SoundEvent> releaseSound) {
        this.releaseSound = releaseSound;
        return this;
    }

    public Holder<SoundEvent> getPressSound() {
        return this.pressSound;
    }

    public Holder<SoundEvent> getReleaseSound() {
        return this.releaseSound;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver() || this.isDisabled()) {
            return false;
        }
        Runnable onClick = this.onClick.get(button);
        Runnable onPress = this.onPress.get(button);
        if (onClick == null && onPress == null) {
            return false;
        }
        this.pressed = true;
        if (this.resetHoverOnPress) {
            this.hoverTime = 1;
        }
        boolean consume = false;
        if (onClick != null) {
            onClick.run();
            consume = true;
        }
        if (onPress != null) {
            consume = true;
        }
        if (this.getPressSound() != null) {
            this.mc().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI(this.getPressSound(), (float)1.0f));
        }
        return consume;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button, boolean consumed) {
        consumed = super.mouseReleased(mouseX, mouseY, button, consumed);
        if (!this.pressed) {
            return consumed;
        }
        Runnable onClick = this.onClick.get(button);
        Runnable onPress = this.onPress.get(button);
        if (onClick == null && onPress == null) {
            return consumed;
        }
        if (this.resetHoverOnPress) {
            this.hoverTime = 1;
        }
        if (!this.isDisabled() && this.isMouseOver()) {
            if (this.pressed && onPress != null) {
                onPress.run();
                consumed = true;
            }
            if (!(this.getReleaseSound() == null || this.toggleState != null && this.toggleState.get().booleanValue())) {
                this.mc().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI(this.getReleaseSound(), (float)1.0f));
            }
        }
        this.pressed = false;
        return consumed;
    }
}

