/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.block;

import codechicken.lib.block.ModularBlock;
import codechicken.lib.block.ModularBlockEntity;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import net.covers1624.quack.util.LazyValue;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class ModularTileBlock<T extends ModularBlockEntity>
extends ModularBlock
implements EntityBlock {
    final Map<String, TileComponent<?>> namedComponents = new HashMap();
    private final LazyValue<BlockEntityType<T>> type;
    private final TickList clientTicks = new TickList();
    private final TickList serverTicks = new TickList();

    public ModularTileBlock(BlockBehaviour.Properties props, Supplier<BlockEntityType<T>> typeSupplier) {
        super(props);
        this.type = new LazyValue(typeSupplier);
    }

    public final <C extends TileComponent<?>> C addComponent(String name, C comp) {
        if (this.namedComponents.containsKey(name)) {
            throw new IllegalArgumentException("DataComponent already exists with name:" + name);
        }
        comp.name = name;
        comp.id = this.namedComponents.size();
        this.namedComponents.put(name, comp);
        return this.addComponent(comp);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)this.type.get()).create(pos, state);
    }

    @Nullable
    public final <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (type != this.type.get()) {
            return null;
        }
        if (level.isClientSide) {
            return this.clientTicks.compileTicker();
        }
        return this.serverTicks.compileTicker();
    }

    private static class TickList {
        private final LinkedList<BlockEntityTicker<?>> tickers = new LinkedList();
        @Nullable
        private BlockEntityTicker<?> compiled;

        private TickList() {
        }

        private void addTickerFirst(BlockEntityTicker<?> pre) {
            assert (this.compiled == null) : "Unable to hot-add new tickers.";
            this.tickers.addFirst(pre);
        }

        private void addTicker(BlockEntityTicker<?> ticker) {
            assert (this.compiled == null) : "Unable to hot-add new tickers.";
            this.tickers.add(ticker);
        }

        @Nullable
        private BlockEntityTicker<?> compileTicker() {
            if (this.compiled != null) {
                return this.compiled;
            }
            if (this.tickers.isEmpty()) {
                return null;
            }
            if (this.tickers.size() == 1) {
                this.compiled = this.tickers.getFirst();
                this.tickers.clear();
            } else {
                BlockEntityTicker[] tickers = this.tickers.toArray(new BlockEntityTicker[0]);
                this.tickers.clear();
                this.compiled = (level, pos, state, tile) -> {
                    for (BlockEntityTicker ticker : tickers) {
                        ticker.tick(level, pos, state, tile);
                    }
                };
            }
            return this.compiled;
        }
    }

    public static abstract class TileComponent<D extends ModularBlockEntity.DataComponent>
    extends ModularBlock.Component {
        String name;
        int id;

        protected abstract D createData(ModularBlockEntity var1);
    }
}

