/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createterminal.menu;

import com.tom.createterminal.behaviour.ContraptionWorld;
import com.tom.createterminal.mixin.CraftingTerminalBlockEntityAccessor;
import com.tom.createterminal.mixin.StorageTerminalBlockEntityAccessor;
import com.tom.storagemod.Config;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.util.Util;
import com.tom.storagemod.util.WorldStates;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public interface ITerminal
extends MenuProvider {
    public StoredItemStack pushStack(StoredItemStack var1);

    public StoredItemStack pullStack(StoredItemStack var1, long var2);

    public void dropItem(ItemStack var1);

    public void updateServer();

    public boolean canInteractWith(Player var1, boolean var2);

    public Level getLevel0();

    public int getChangeCount();

    public ContraptionWorld getContraption();

    public static interface ICraftingTerminalImpl
    extends ITerminalImpl {
        @Override
        default public void updateServer() {
            ITerminalImpl.super.updateServer();
            ((CraftingTerminalBlockEntityAccessor)((Object)this)).setCraftingCooldown(0);
        }
    }

    public static interface ITerminalImpl
    extends ITerminal {
        @Override
        default public void dropItem(ItemStack st) {
            this.getContraption().popItem(st);
        }

        @Override
        default public void updateServer() {
            StorageTerminalBlockEntityAccessor ac = (StorageTerminalBlockEntityAccessor)((Object)this);
            if (ac.isUpdateItems()) {
                CombinedInvWrapper itemHandler = this.getContraption().getContraption().getStorage().getAllItems();
                IInventoryAccess.IInventoryChangeTracker tr = WorldStates.getTracker((IItemHandler)itemHandler);
                long ct = tr.getChangeTracker(this.getLevel0());
                if (ac.getChangeTracker() != ct) {
                    ac.setChangeTracker(ct);
                    if (Config.get().runMultithreaded) {
                        ac.setItems(tr.streamWrappedStacks(true).collect(Collectors.groupingByConcurrent(Function.identity(), Util.reducingWithCopy(null, StoredItemStack::merge, StoredItemStack::new))));
                    } else {
                        HashMap<StoredItemStack, StoredItemStack> items = new HashMap<StoredItemStack, StoredItemStack>();
                        tr.streamWrappedStacks(false).forEach(s -> items.merge((StoredItemStack)s, (StoredItemStack)s, StoredItemStack::merge));
                        items.replaceAll((k, v) -> new StoredItemStack(v));
                        ac.setItems(items);
                    }
                    ac.setChangeCount(this.getChangeCount() + 1);
                }
                ac.setUpdateItems(false);
            }
        }

        @Override
        default public boolean canInteractWith(Player player, boolean menuCheck) {
            return this.getContraption().isValid() && player.distanceToSqr(this.getContraption().getActualPosition()) < 64.0;
        }

        @Override
        default public StoredItemStack pullStack(StoredItemStack stack, long max) {
            CombinedInvWrapper itemHandler = this.getContraption().getContraption().getStorage().getAllItems();
            if (stack != null && itemHandler != null && max > 0L) {
                ItemStack st = stack.getStack();
                StoredItemStack ret = null;
                for (int i = itemHandler.getSlots() - 1; i >= 0; --i) {
                    ItemStack pulled;
                    ItemStack s = itemHandler.getStackInSlot(i);
                    if (!ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)st) || (pulled = itemHandler.extractItem(i, (int)max, false)).isEmpty()) continue;
                    if (ret == null) {
                        ret = new StoredItemStack(pulled);
                    } else {
                        ret.grow((long)pulled.getCount());
                    }
                    if ((max -= (long)pulled.getCount()) < 1L) break;
                }
                return ret;
            }
            return null;
        }

        @Override
        default public StoredItemStack pushStack(StoredItemStack stack) {
            CombinedInvWrapper itemHandler = this.getContraption().getContraption().getStorage().getAllItems();
            if (stack != null && itemHandler != null) {
                ItemStack is = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack.getActualStack(), (boolean)false);
                if (is.isEmpty()) {
                    return null;
                }
                return new StoredItemStack(is);
            }
            return stack;
        }
    }
}

