/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.mixin.models.cullshape;

import ca.fxco.moreculling.MoreCulling;
import ca.fxco.moreculling.api.blockstate.StateCullingShapeCache;
import ca.fxco.moreculling.api.model.BakedOpacity;
import ca.fxco.moreculling.utils.DirectionUtils;
import java.util.Arrays;
import net.minecraft.Util;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateBase_cullShapeMixin
implements StateCullingShapeCache {
    @Shadow
    @Final
    private boolean canOcclude;
    @Unique
    private static final VoxelShape[] moreculling$EMPTY_OCCLUSION_SHAPES = (VoxelShape[])Util.make((Object)new VoxelShape[DirectionUtils.DIRECTIONS.length], p_362173_ -> Arrays.fill(p_362173_, Shapes.empty()));
    @Unique
    private static final VoxelShape[] moreculling$FULL_BLOCK_OCCLUSION_SHAPES = (VoxelShape[])Util.make((Object)new VoxelShape[DirectionUtils.DIRECTIONS.length], p_361879_ -> Arrays.fill(p_361879_, Shapes.block()));
    @Unique
    private VoxelShape[] moreculling$cullingShapesByFace;

    @Shadow
    protected abstract BlockState asState();

    @Shadow
    public abstract Block getBlock();

    @Override
    public void moreculling$initShapeCache() {
        BakedModel model;
        VoxelShape voxelShape = null;
        if (!this.canOcclude && MoreCulling.blockRenderManager != null && (model = MoreCulling.blockRenderManager.getBlockModel(this.asState())) != null && !this.asState().hasProperty((Property)BlockStateProperties.FACING)) {
            voxelShape = ((BakedOpacity)model).moreculling$getCullingShape(this.asState());
        }
        if (voxelShape == null) {
            voxelShape = this.getBlock().getOcclusionShape(this.asState(), (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
        }
        if (voxelShape == Shapes.empty() || voxelShape.isEmpty()) {
            this.moreculling$cullingShapesByFace = moreculling$EMPTY_OCCLUSION_SHAPES;
        } else if (Block.isShapeFullBlock((VoxelShape)voxelShape)) {
            this.moreculling$cullingShapesByFace = moreculling$FULL_BLOCK_OCCLUSION_SHAPES;
        } else {
            this.moreculling$cullingShapesByFace = new VoxelShape[DirectionUtils.DIRECTIONS.length];
            for (Direction direction : DirectionUtils.DIRECTIONS) {
                this.moreculling$cullingShapesByFace[direction.ordinal()] = voxelShape.getFaceShape(direction);
            }
        }
    }

    @Override
    public VoxelShape moreculling$getFaceCullingShape(Direction face) {
        return this.moreculling$cullingShapesByFace[face.ordinal()];
    }
}

