/*
 * Decompiled with CFR 0.152.
 */
package net.zjjohn121110.aethersdelight.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class SugarFromSwetsModifier
extends LootModifier {
    public static final Supplier<MapCodec<SugarFromSwetsModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> SugarFromSwetsModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(m -> m.addedItem), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(m -> m.count))).apply((Applicative)inst, SugarFromSwetsModifier::new)));
    private final Item addedItem;
    private final int count;

    protected SugarFromSwetsModifier(LootItemCondition[] conditionsIn, Item addedItemIn, int count) {
        super(conditionsIn);
        this.addedItem = addedItemIn;
        this.count = count;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!ModList.get().isLoaded("aether_redux")) {
            ItemStack addedStack = new ItemStack((ItemLike)this.addedItem, this.count);
            if (addedStack.getCount() < addedStack.getMaxStackSize()) {
                generatedLoot.add((Object)addedStack);
            } else {
                ItemStack subStack;
                for (int i = addedStack.getCount(); i > 0; i -= subStack.getCount()) {
                    subStack = addedStack.copy();
                    subStack.setCount(Math.min(addedStack.getMaxStackSize(), i));
                    generatedLoot.add((Object)subStack);
                }
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

