/*
 * Decompiled with CFR 0.152.
 */
package net.zjjohn121110.aethersdelight.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.zjjohn121110.aethersdelight.block.entity.AethersDelightBlockEntity;
import net.zjjohn121110.aethersdelight.block.entity.HolystoneSmokerBlockEntity;
import org.jetbrains.annotations.Nullable;

public class HolystoneSmokerBlock
extends AbstractFurnaceBlock {
    public static final MapCodec<HolystoneSmokerBlock> CODEC = HolystoneSmokerBlock.simpleCodec(HolystoneSmokerBlock::new);

    public HolystoneSmokerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected MapCodec<? extends AbstractFurnaceBlock> codec() {
        return CODEC;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide() ? null : HolystoneSmokerBlock.createTickerHelper(blockEntityType, AethersDelightBlockEntity.HOLYSTONE_SMOKER.get(), AbstractFurnaceBlockEntity::serverTick);
    }

    protected void openContainer(Level level, BlockPos blockPos, Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(blockPos)) instanceof HolystoneSmokerBlockEntity) {
            HolystoneSmokerBlockEntity smokerBlockEntity = (HolystoneSmokerBlockEntity)blockEntity;
            player.openMenu((MenuProvider)smokerBlockEntity);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new HolystoneSmokerBlockEntity(blockPos, blockState);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.getX() + 0.5;
            double d1 = pos.getY();
            double d2 = (double)pos.getZ() + 0.5;
            if (random.nextDouble() < 0.1) {
                level.playLocalSound(d0, d1, d2, SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1 + 1.1, d2, 0.0, 0.0, 0.0);
        }
    }
}

