/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire;

import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.entity.WildfireShieldDebrisEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.WildfireBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class WildfireBarrageAttackTask
extends Behavior<WildfireEntity> {
    private int shieldDebrisFired;
    private int shieldDebrisCooldown;
    private boolean canDoMeeleAttack;
    private LivingEntity attackTarget;
    private int attackTargetIsNotVisibleTicks;
    private static final int BARRAGE_ATTACK_DURATION = 180;
    private static final int MAX_FIREBALLS_TO_BE_FIRED = 30;

    public WildfireBarrageAttackTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get()), (Object)MemoryStatus.VALUE_ABSENT), 180);
    }

    protected boolean checkExtraStartConditions(ServerLevel world, WildfireEntity wildfire) {
        LivingEntity attackTarget = wildfire.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if (attackTarget == null || !attackTarget.isAlive() || attackTarget instanceof Player && (attackTarget.isSpectator() || ((Player)attackTarget).isCreative())) {
            return false;
        }
        this.attackTarget = attackTarget;
        return true;
    }

    protected void start(ServerLevel world, WildfireEntity wildfire, long time) {
        wildfire.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        wildfire.getNavigation().stop();
        BehaviorUtils.lookAtEntity((LivingEntity)wildfire, (LivingEntity)this.attackTarget);
        wildfire.getLookControl().setLookAt((Entity)this.attackTarget);
        WildfireBrain.setAttackTarget(wildfire, this.attackTarget);
        this.shieldDebrisFired = 0;
        this.attackTargetIsNotVisibleTicks = 0;
        this.canDoMeeleAttack = true;
    }

    protected boolean canStillUse(ServerLevel world, WildfireEntity wildfire, long time) {
        if (!this.attackTarget.isAlive()) {
            this.attackTarget = wildfire.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).orElse(null);
        }
        if (this.attackTarget == null || !this.attackTarget.isAlive() || !this.attackTarget.isAlive() || this.attackTarget instanceof Player && (this.attackTarget.isSpectator() || ((Player)this.attackTarget).isCreative()) || this.shieldDebrisFired > 30) {
            return false;
        }
        Player nearestVisibleTargetablePlayer = wildfire.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).orElse(null);
        return nearestVisibleTargetablePlayer == null || !nearestVisibleTargetablePlayer.isAlive() || !(wildfire.distanceTo((Entity)nearestVisibleTargetablePlayer) <= 6.0f) || !wildfire.getBrain().checkMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get(), MemoryStatus.VALUE_ABSENT);
    }

    protected void tick(ServerLevel serverLevel, WildfireEntity wildfire, long time) {
        wildfire.getLookControl().setLookAt((Entity)this.attackTarget);
        boolean isAttackTargetVisible = wildfire.getSensing().hasLineOfSight((Entity)this.attackTarget);
        this.attackTargetIsNotVisibleTicks = isAttackTargetVisible ? 0 : ++this.attackTargetIsNotVisibleTicks;
        double targetX = this.attackTarget.getX() - wildfire.getX();
        double targetY = this.attackTarget.getY(0.5) - wildfire.getY(0.5);
        double targetZ = this.attackTarget.getZ() - wildfire.getZ();
        if (this.shieldDebrisCooldown > 0) {
            --this.shieldDebrisCooldown;
            return;
        }
        if (this.canDoMeeleAttack && wildfire.distanceTo((Entity)this.attackTarget) < 3.0f) {
            wildfire.doHurtTarget((Entity)this.attackTarget);
            this.canDoMeeleAttack = false;
        } else {
            this.canDoMeeleAttack = true;
        }
        if (this.attackTargetIsNotVisibleTicks > 5) {
            wildfire.getMoveControl().setWantedPosition(this.attackTarget.getX(), this.attackTarget.getY(), this.attackTarget.getZ(), (double)wildfire.getSpeed());
        }
        double distanceToAttackTarget = wildfire.distanceToSqr((Entity)this.attackTarget);
        double h = Math.sqrt(Math.sqrt(distanceToAttackTarget)) * 0.5;
        if (!wildfire.isSilent()) {
            wildfire.playShootSound();
            wildfire.level().levelEvent(null, 1018, wildfire.blockPosition(), 0);
        }
        RandomSource random = wildfire.getRandom();
        for (int i = 0; i < 8; ++i) {
            WildfireShieldDebrisEntity shieldDebris = new WildfireShieldDebrisEntity((Level)serverLevel, (LivingEntity)wildfire, new Vec3(random.triangle(targetX, 2.297 * h), targetY, random.triangle(targetZ, 2.297 * h)));
            shieldDebris.setPos(shieldDebris.getX(), wildfire.getY(0.5) + 0.5, shieldDebris.getZ());
            wildfire.level().addFreshEntity((Entity)shieldDebris);
            ++this.shieldDebrisFired;
        }
        this.shieldDebrisCooldown = 10;
    }

    protected void stop(ServerLevel world, WildfireEntity wildfire, long time) {
        WildfireBrain.setBarrageAttackCooldown(wildfire);
    }
}

