/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.block;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.block.OnUseOxidizable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public final class OxidizableLightningRodBlock
extends LightningRodBlock
implements WeatheringCopper {
    private final WeatheringCopper.WeatherState oxidationLevel;

    public OxidizableLightningRodBlock(WeatheringCopper.WeatherState oxidationLevel, BlockBehaviour.Properties settings) {
        super(settings);
        this.oxidationLevel = oxidationLevel;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (FriendsAndFoes.getConfig().enableLightningRodOxidation) {
            this.changeOverTime(state, world, pos, random);
        }
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        if (!FriendsAndFoes.getConfig().enableLightningRodOxidation) {
            return false;
        }
        return this.getAge().ordinal() < WeatheringCopper.WeatherState.OXIDIZED.ordinal();
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.oxidationLevel;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionResult actionResult = OnUseOxidizable.onOxidizableUse(state, world, pos, player, hit);
        if (actionResult.consumesAction()) {
            return actionResult;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }
}

