/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CatwalkRailingBlock
extends Block
implements IWrenchable,
ProperWaterloggedBlock {
    private static final VoxelShape VOXEL_NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0);
    private static final VoxelShape VOXEL_SOUTH = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape VOXEL_EAST = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape VOXEL_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0);
    public static final BooleanProperty NORTH_FENCE = BlockStateProperties.NORTH;
    public static final BooleanProperty SOUTH_FENCE = BlockStateProperties.SOUTH;
    public static final BooleanProperty EAST_FENCE = BlockStateProperties.EAST;
    public static final BooleanProperty WEST_FENCE = BlockStateProperties.WEST;

    public CatwalkRailingBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH_FENCE, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST_FENCE, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST_FENCE, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Vec3 subbox = context.getClickLocation().subtract(pos.getCenter());
        Direction face = context.getClickedFace();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        double x = subbox.x;
        double z = subbox.z;
        if (level.isClientSide() || face == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        if (face == Direction.UP) {
            boolean bottomleft = x < -z;
            boolean topleft = x < z;
            Direction dir = Direction.WEST;
            if (!bottomleft && topleft) {
                dir = Direction.SOUTH;
            }
            if (!bottomleft && !topleft) {
                dir = Direction.EAST;
            }
            if (bottomleft && !topleft) {
                dir = Direction.NORTH;
            }
            if (bottomleft && topleft) {
                dir = Direction.WEST;
            }
            if (((Boolean)state.getValue((Property)CatwalkRailingBlock.fromDirection(dir))).booleanValue()) {
                state = (BlockState)state.setValue((Property)CatwalkRailingBlock.fromDirection(dir), (Comparable)Boolean.valueOf(false));
                level.setBlock(pos, state, 3);
                IWrenchable.playRemoveSound((Level)level, (BlockPos)pos);
                if (!player.getAbilities().instabuild) {
                    player.addItem(new ItemStack((ItemLike)state.getBlock().asItem()));
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (x == 0.375 || x == -0.375 || z == 0.375 || z == -0.375) {
            state = (BlockState)state.setValue((Property)CatwalkRailingBlock.fromDirection(face.getOpposite()), (Comparable)Boolean.valueOf(false));
        }
        if (x == 0.5 || x == -0.5 || z == 0.5 || z == -0.5) {
            if (!((Boolean)state.getValue((Property)CatwalkRailingBlock.fromDirection(face))).booleanValue()) {
                if (x >= 0.375) {
                    state = (BlockState)state.setValue((Property)EAST_FENCE, (Comparable)Boolean.valueOf(false));
                }
                if (x <= -0.375) {
                    state = (BlockState)state.setValue((Property)WEST_FENCE, (Comparable)Boolean.valueOf(false));
                }
                if (z <= -0.375) {
                    state = (BlockState)state.setValue((Property)NORTH_FENCE, (Comparable)Boolean.valueOf(false));
                }
                if (z >= 0.375) {
                    state = (BlockState)state.setValue((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf(false));
                }
            } else {
                state = (BlockState)state.setValue((Property)CatwalkRailingBlock.fromDirection(face), (Comparable)Boolean.valueOf(false));
            }
        }
        level.setBlock(pos, state, 3);
        IWrenchable.playRemoveSound((Level)level, (BlockPos)pos);
        if (!player.getAbilities().instabuild) {
            player.addItem(new ItemStack((ItemLike)state.getBlock().asItem()));
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = ctx.getHorizontalDirection();
        FluidState fluid = ctx.getLevel().getFluidState(ctx.getClickedPos());
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH_FENCE, (Comparable)Boolean.valueOf(facing == Direction.NORTH))).setValue((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf(facing == Direction.SOUTH))).setValue((Property)EAST_FENCE, (Comparable)Boolean.valueOf(facing == Direction.EAST))).setValue((Property)WEST_FENCE, (Comparable)Boolean.valueOf(facing == Direction.WEST))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH_FENCE});
        builder.add(new Property[]{SOUTH_FENCE});
        builder.add(new Property[]{EAST_FENCE});
        builder.add(new Property[]{WEST_FENCE});
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (targetedFace.getAxis() == Direction.Axis.Y) {
            int state = ((Boolean)originalState.getValue((Property)NORTH_FENCE) != false ? 8 : 0) + ((Boolean)originalState.getValue((Property)EAST_FENCE) != false ? 4 : 0) + ((Boolean)originalState.getValue((Property)SOUTH_FENCE) != false ? 2 : 0) + ((Boolean)originalState.getValue((Property)WEST_FENCE) != false ? 1 : 0);
            return (BlockState)((BlockState)((BlockState)((BlockState)originalState.setValue((Property)NORTH_FENCE, (Comparable)Boolean.valueOf((state & 1) == 1))).setValue((Property)EAST_FENCE, (Comparable)Boolean.valueOf((state & 8) == 8))).setValue((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf((state & 4) == 4))).setValue((Property)WEST_FENCE, (Comparable)Boolean.valueOf((state & 2) == 2));
        }
        return originalState;
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return this.getInteractionShape(state, reader, pos);
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter world, BlockPos pos) {
        VoxelShape shape = Shapes.empty();
        if (((Boolean)state.getValue((Property)NORTH_FENCE)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)VOXEL_NORTH, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)SOUTH_FENCE)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)VOXEL_SOUTH, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)EAST_FENCE)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)VOXEL_EAST, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)WEST_FENCE)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)VOXEL_WEST, (BooleanOp)BooleanOp.OR);
        }
        return shape;
    }

    public boolean canPlaceLiquid(@Nullable Player playerEntity, BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false && fluid == Fluids.WATER;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (this.isEmpty(state)) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 0);
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    public static boolean isRailing(ItemStack test) {
        return test.getItem() instanceof BlockItem && CatwalkRailingBlock.isRailing(((BlockItem)test.getItem()).getBlock());
    }

    public static boolean isRailing(Block test) {
        return test instanceof CatwalkRailingBlock;
    }

    public static BooleanProperty fromDirection(Direction face) {
        return switch (face) {
            case Direction.SOUTH -> SOUTH_FENCE;
            case Direction.EAST -> EAST_FENCE;
            case Direction.WEST -> WEST_FENCE;
            default -> NORTH_FENCE;
        };
    }

    public boolean isEmpty(BlockState state) {
        boolean safe = false;
        for (Direction dir : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
            safe |= ((Boolean)state.getValue((Property)CatwalkRailingBlock.fromDirection(dir))).booleanValue();
        }
        return !safe;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        boolean north = (Boolean)state.getValue((Property)NORTH_FENCE);
        boolean south = (Boolean)state.getValue((Property)SOUTH_FENCE);
        boolean east = (Boolean)state.getValue((Property)EAST_FENCE);
        boolean west = (Boolean)state.getValue((Property)WEST_FENCE);
        switch (rotation) {
            case CLOCKWISE_90: {
                north = (Boolean)state.getValue((Property)WEST_FENCE);
                south = (Boolean)state.getValue((Property)EAST_FENCE);
                east = (Boolean)state.getValue((Property)NORTH_FENCE);
                west = (Boolean)state.getValue((Property)SOUTH_FENCE);
                break;
            }
            case CLOCKWISE_180: {
                north = (Boolean)state.getValue((Property)SOUTH_FENCE);
                south = (Boolean)state.getValue((Property)NORTH_FENCE);
                east = (Boolean)state.getValue((Property)WEST_FENCE);
                west = (Boolean)state.getValue((Property)EAST_FENCE);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                north = (Boolean)state.getValue((Property)EAST_FENCE);
                south = (Boolean)state.getValue((Property)WEST_FENCE);
                east = (Boolean)state.getValue((Property)SOUTH_FENCE);
                west = (Boolean)state.getValue((Property)NORTH_FENCE);
                break;
            }
            case NONE: {
                north = (Boolean)state.getValue((Property)NORTH_FENCE);
                south = (Boolean)state.getValue((Property)SOUTH_FENCE);
                east = (Boolean)state.getValue((Property)EAST_FENCE);
                west = (Boolean)state.getValue((Property)WEST_FENCE);
            }
        }
        BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH_FENCE, (Comparable)Boolean.valueOf(north))).setValue((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf(south))).setValue((Property)EAST_FENCE, (Comparable)Boolean.valueOf(east))).setValue((Property)WEST_FENCE, (Comparable)Boolean.valueOf(west));
        return newState;
    }
}

