/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.item;

import cn.mcmod_mmf.mmlib.item.IFoodLike;
import cn.mcmod_mmf.mmlib.item.info.FoodInfo;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ItemFoodSeeds
extends ItemNameBlockItem
implements IFoodLike {
    private final FoodInfo info;

    public ItemFoodSeeds(Block block, Item.Properties prop, FoodInfo info) {
        super(block, prop);
        this.info = info;
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        FoodProperties.Builder food = new FoodProperties.Builder().nutrition(this.getFoodInfo().getAmount()).saturationModifier(this.getFoodInfo().getCalories());
        if (this.getFoodInfo().isAlwaysEat()) {
            food.alwaysEdible();
        }
        if (this.getFoodInfo().getEatTime() <= 16) {
            food.fast();
        }
        this.getFoodInfo().getEffects().forEach(k -> food.effect((Supplier)k.getFirst(), ((Float)k.getSecond()).floatValue()));
        return food.build();
    }

    public int getUseDuration(ItemStack stack, LivingEntity p_344979_) {
        if (this.getFoodInfo() != null) {
            return this.getFoodInfo().getEatTime();
        }
        return super.getUseDuration(stack, p_344979_);
    }

    @Override
    public FoodInfo getFoodInfo() {
        return this.info;
    }

    @Override
    public boolean shouldAddEffectTooltips() {
        return this.info != null;
    }
}

