/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.item;

import cn.mcmod_mmf.mmlib.item.info.FoodInfo;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public interface IFoodLike {
    public FoodInfo getFoodInfo();

    public boolean shouldAddEffectTooltips();

    default public void addEffectTooltips(Consumer<Component> tooltipAdder, float durationFactor, float tickRate) {
        List<Pair<Supplier<MobEffectInstance>, Float>> effectList = this.getFoodInfo().getEffects();
        ArrayList attributeList = Lists.newArrayList();
        if (effectList.isEmpty()) {
            tooltipAdder.accept((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
            return;
        }
        for (Pair<Supplier<MobEffectInstance>, Float> effectPair : effectList) {
            Supplier instance = (Supplier)effectPair.getFirst();
            MutableComponent mutableComponent = Component.translatable((String)((MobEffectInstance)instance.get()).getDescriptionId());
            MobEffect effect = (MobEffect)((MobEffectInstance)instance.get()).getEffect().value();
            effect.createModifiers(((MobEffectInstance)instance.get()).getAmplifier(), (attributeHolder, attributeModifier) -> attributeList.add(new Pair((Object)((Attribute)attributeHolder.value()), attributeModifier)));
            if (((MobEffectInstance)instance.get()).getAmplifier() > 0) {
                mutableComponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutableComponent, Component.translatable((String)("potion.potency." + ((MobEffectInstance)instance.get()).getAmplifier()))});
            }
            if (((MobEffectInstance)instance.get()).getDuration() > 20) {
                mutableComponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableComponent, MobEffectUtil.formatDuration((MobEffectInstance)((MobEffectInstance)instance.get()), (float)1.0f, (float)tickRate)});
            }
            tooltipAdder.accept((Component)mutableComponent.withStyle(effect.getCategory().getTooltipFormatting()));
        }
        if (!attributeList.isEmpty()) {
            tooltipAdder.accept(CommonComponents.EMPTY);
            tooltipAdder.accept((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair pair : attributeList) {
                AttributeModifier attributemodifier = (AttributeModifier)pair.getSecond();
                double amount = attributemodifier.amount();
                double formattedAmount = attributemodifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && attributemodifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? attributemodifier.amount() : attributemodifier.amount() * 100.0;
                if (amount > 0.0) {
                    tooltipAdder.accept((Component)Component.translatable((String)("attribute.modifier.plus." + attributemodifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(formattedAmount), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                tooltipAdder.accept((Component)Component.translatable((String)("attribute.modifier.take." + attributemodifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(formattedAmount *= -1.0), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.RED));
            }
        }
    }
}

