/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.client.model;

import cn.mcmod_mmf.mmlib.client.model.BedrockEntityModel;
import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockPart;
import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import cn.mcmod_mmf.mmlib.utils.BedrockAnimationUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class BedrockHumanoidModel<T extends LivingEntity>
extends BedrockEntityModel<T> {
    public static final float OVERLAY_SCALE = 0.25f;
    public static final float HAT_OVERLAY_SCALE = 0.5f;
    public BedrockPart head;
    public BedrockPart body;
    public BedrockPart rightArm;
    public BedrockPart leftArm;
    public BedrockPart rightLeg;
    public BedrockPart leftLeg;
    public HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    public HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;
    public boolean crouching;
    public float swimAmount;

    public BedrockHumanoidModel() {
    }

    public BedrockHumanoidModel(BedrockModelPOJO pojo) {
        super(pojo);
    }

    @Override
    public void loadModel(BedrockModelPOJO pojo) {
        super.loadModel(pojo);
        this.head = this.getChild("head");
        this.body = this.getChild("body");
        this.rightArm = this.getChild("right_arm");
        this.leftArm = this.getChild("left_arm");
        this.rightLeg = this.getChild("right_leg");
        this.leftLeg = this.getChild("left_leg");
    }

    protected Iterable<BedrockPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<BedrockPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public void prepareMobModel(T entity, float p_102862_, float p_102863_, float p_102864_) {
        this.swimAmount = entity.getSwimAmount(p_102864_);
        super.prepareMobModel(entity, p_102862_, p_102863_, p_102864_);
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag2;
        boolean flag = entity.getFallFlyingTicks() > 4;
        boolean flag1 = entity.isVisuallySwimming();
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = flag ? -0.7853982f : (this.swimAmount > 0.0f ? (flag1 ? this.rotlerpRad(this.swimAmount, this.head.xRot, -0.7853982f) : this.rotlerpRad(this.swimAmount, this.head.xRot, headPitch * ((float)Math.PI / 180))) : headPitch * ((float)Math.PI / 180));
        this.body.yRot = 0.0f;
        this.rightArm.z = 0.0f;
        this.rightArm.x = -5.0f;
        this.leftArm.z = 0.0f;
        this.leftArm.x = 5.0f;
        float f = 1.0f;
        if (flag) {
            f = (float)entity.getDeltaMovement().lengthSqr();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / f;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / f;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        this.rightLeg.zRot = 0.0f;
        this.leftLeg.zRot = 0.0f;
        if (this.riding) {
            this.rightArm.xRot += -0.62831855f;
            this.leftArm.xRot += -0.62831855f;
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = 0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        }
        this.rightArm.yRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        boolean bl = flag2 = entity.getMainArm() == HumanoidArm.RIGHT;
        if (entity.isUsingItem()) {
            boolean flag3;
            boolean bl2 = flag3 = entity.getUsedItemHand() == InteractionHand.MAIN_HAND;
            if (flag3 == flag2) {
                this.poseRightArm(entity);
            } else {
                this.poseLeftArm(entity);
            }
        } else {
            boolean flag4;
            boolean bl3 = flag4 = flag2 ? this.leftArmPose.isTwoHanded() : this.rightArmPose.isTwoHanded();
            if (flag2 != flag4) {
                this.poseLeftArm(entity);
                this.poseRightArm(entity);
            } else {
                this.poseRightArm(entity);
                this.poseLeftArm(entity);
            }
        }
        this.setupAttackAnimation(entity, ageInTicks);
        if (this.crouching) {
            this.body.xRot = 0.5f;
            this.rightArm.xRot += 0.4f;
            this.leftArm.xRot += 0.4f;
            this.rightLeg.z = 4.0f;
            this.leftLeg.z = 4.0f;
            this.rightLeg.y = 12.2f;
            this.leftLeg.y = 12.2f;
            this.head.y = 4.2f;
            this.body.y = 3.2f;
            this.leftArm.y = 5.2f;
            this.rightArm.y = 5.2f;
        } else {
            this.body.xRot = 0.0f;
            this.rightLeg.z = 0.1f;
            this.leftLeg.z = 0.1f;
            this.rightLeg.y = 12.0f;
            this.leftLeg.y = 12.0f;
            this.head.y = 0.0f;
            this.body.y = 0.0f;
            this.leftArm.y = 2.0f;
            this.rightArm.y = 2.0f;
        }
        if (this.rightArmPose != HumanoidModel.ArmPose.SPYGLASS) {
            BedrockAnimationUtils.bobBedrockPart(this.rightArm, ageInTicks, 1.0f);
        }
        if (this.leftArmPose != HumanoidModel.ArmPose.SPYGLASS) {
            BedrockAnimationUtils.bobBedrockPart(this.leftArm, ageInTicks, -1.0f);
        }
        if (this.swimAmount > 0.0f) {
            float f2;
            float f5 = limbSwing % 26.0f;
            HumanoidArm humanoidarm = this.getAttackArm(entity);
            float f1 = humanoidarm == HumanoidArm.RIGHT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            float f3 = f2 = humanoidarm == HumanoidArm.LEFT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            if (!entity.isUsingItem()) {
                if (f5 < 14.0f) {
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 0.0f);
                    this.rightArm.xRot = Mth.lerp((float)f1, (float)this.rightArm.xRot, (float)0.0f);
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, (float)Math.PI + 1.8707964f * this.quadraticArmUpdate(f5) / this.quadraticArmUpdate(14.0f));
                    this.rightArm.zRot = Mth.lerp((float)f1, (float)this.rightArm.zRot, (float)((float)Math.PI - 1.8707964f * this.quadraticArmUpdate(f5) / this.quadraticArmUpdate(14.0f)));
                } else if (f5 >= 14.0f && f5 < 22.0f) {
                    float f6 = (f5 - 14.0f) / 8.0f;
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 1.5707964f * f6);
                    this.rightArm.xRot = Mth.lerp((float)f1, (float)this.rightArm.xRot, (float)(1.5707964f * f6));
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, 5.012389f - 1.8707964f * f6);
                    this.rightArm.zRot = Mth.lerp((float)f1, (float)this.rightArm.zRot, (float)(1.2707963f + 1.8707964f * f6));
                } else if (f5 >= 22.0f && f5 < 26.0f) {
                    float f32 = (f5 - 22.0f) / 4.0f;
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 1.5707964f - 1.5707964f * f32);
                    this.rightArm.xRot = Mth.lerp((float)f1, (float)this.rightArm.xRot, (float)(1.5707964f - 1.5707964f * f32));
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, (float)Math.PI);
                    this.rightArm.zRot = Mth.lerp((float)f1, (float)this.rightArm.zRot, (float)((float)Math.PI));
                }
            }
            this.leftLeg.xRot = Mth.lerp((float)this.swimAmount, (float)this.leftLeg.xRot, (float)(0.3f * Mth.cos((float)(limbSwing * 0.33333334f + (float)Math.PI))));
            this.rightLeg.xRot = Mth.lerp((float)this.swimAmount, (float)this.rightLeg.xRot, (float)(0.3f * Mth.cos((float)(limbSwing * 0.33333334f))));
        }
    }

    protected void poseRightArm(T p_102876_) {
        switch (this.rightArmPose) {
            case EMPTY: {
                this.rightArm.yRot = 0.0f;
                break;
            }
            case BLOCK: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.9424779f;
                this.rightArm.yRot = -0.5235988f;
                break;
            }
            case ITEM: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.31415927f;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - (float)Math.PI;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.rightArm.yRot = -0.1f + this.head.yRot;
                this.leftArm.yRot = 0.1f + this.head.yRot + 0.4f;
                this.rightArm.xRot = -1.5707964f + this.head.xRot;
                this.leftArm.xRot = -1.5707964f + this.head.xRot;
                break;
            }
            case CROSSBOW_CHARGE: {
                BedrockAnimationUtils.animateCrossbowCharge(this.rightArm, this.leftArm, p_102876_, true);
                break;
            }
            case CROSSBOW_HOLD: {
                BedrockAnimationUtils.animateCrossbowHold(this.rightArm, this.leftArm, this.head, true);
                break;
            }
            case SPYGLASS: {
                this.rightArm.xRot = Mth.clamp((float)(this.head.xRot - 1.9198622f - (p_102876_.isCrouching() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.rightArm.yRot = this.head.yRot - 0.2617994f;
            }
            case TOOT_HORN: {
                break;
            }
        }
    }

    protected void poseLeftArm(T p_102879_) {
        switch (this.leftArmPose) {
            case EMPTY: {
                this.leftArm.yRot = 0.0f;
                break;
            }
            case BLOCK: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.9424779f;
                this.leftArm.yRot = 0.5235988f;
                break;
            }
            case ITEM: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.31415927f;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - (float)Math.PI;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.rightArm.yRot = -0.1f + this.head.yRot - 0.4f;
                this.leftArm.yRot = 0.1f + this.head.yRot;
                this.rightArm.xRot = -1.5707964f + this.head.xRot;
                this.leftArm.xRot = -1.5707964f + this.head.xRot;
                break;
            }
            case CROSSBOW_CHARGE: {
                BedrockAnimationUtils.animateCrossbowCharge(this.rightArm, this.leftArm, p_102879_, false);
                break;
            }
            case CROSSBOW_HOLD: {
                BedrockAnimationUtils.animateCrossbowHold(this.rightArm, this.leftArm, this.head, false);
                break;
            }
            case SPYGLASS: {
                this.leftArm.xRot = Mth.clamp((float)(this.head.xRot - 1.9198622f - (p_102879_.isCrouching() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.leftArm.yRot = this.head.yRot + 0.2617994f;
            }
            case TOOT_HORN: {
                break;
            }
        }
    }

    protected void setupAttackAnimation(T p_102858_, float p_102859_) {
        if (!(this.attackTime <= 0.0f)) {
            HumanoidArm humanoidarm = this.getAttackArm(p_102858_);
            BedrockPart modelpart = this.getArm(humanoidarm);
            float f = this.attackTime;
            this.body.yRot = Mth.sin((float)(Mth.sqrt((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (humanoidarm == HumanoidArm.LEFT) {
                this.body.yRot *= -1.0f;
            }
            this.rightArm.z = Mth.sin((float)this.body.yRot) * 5.0f;
            this.rightArm.x = -Mth.cos((float)this.body.yRot) * 5.0f;
            this.leftArm.z = -Mth.sin((float)this.body.yRot) * 5.0f;
            this.leftArm.x = Mth.cos((float)this.body.yRot) * 5.0f;
            this.rightArm.yRot += this.body.yRot;
            this.leftArm.yRot += this.body.yRot;
            this.leftArm.xRot += this.body.yRot;
            f = 1.0f - this.attackTime;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.sin((float)(f * (float)Math.PI));
            float f2 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
            modelpart.xRot -= f1 * 1.2f + f2;
            modelpart.yRot += this.body.yRot * 2.0f;
            modelpart.zRot += Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
        }
    }

    protected float rotlerpRad(float p_102836_, float p_102837_, float p_102838_) {
        float f = (p_102838_ - p_102837_) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return p_102837_ + p_102836_ * f;
    }

    protected float quadraticArmUpdate(float p_102834_) {
        return -65.0f * p_102834_ + p_102834_ * p_102834_;
    }

    public void copyPropertiesTo(BedrockHumanoidModel<T> p_102873_) {
        super.copyPropertiesTo(p_102873_);
        p_102873_.leftArmPose = this.leftArmPose;
        p_102873_.rightArmPose = this.rightArmPose;
        p_102873_.crouching = this.crouching;
        p_102873_.head.copyFrom(this.head);
        p_102873_.body.copyFrom(this.body);
        p_102873_.rightArm.copyFrom(this.rightArm);
        p_102873_.leftArm.copyFrom(this.leftArm);
        p_102873_.rightLeg.copyFrom(this.rightLeg);
        p_102873_.leftLeg.copyFrom(this.leftLeg);
    }

    public void setAllVisible(boolean p_102880_) {
        this.head.visible = p_102880_;
        this.body.visible = p_102880_;
        this.rightArm.visible = p_102880_;
        this.leftArm.visible = p_102880_;
        this.rightLeg.visible = p_102880_;
        this.leftLeg.visible = p_102880_;
    }

    public void translateToHand(HumanoidArm p_102854_, PoseStack p_102855_) {
        this.getArm(p_102854_).translateAndRotate(p_102855_);
    }

    protected BedrockPart getArm(HumanoidArm p_102852_) {
        return p_102852_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public BedrockPart getHead() {
        return this.head;
    }

    protected HumanoidArm getAttackArm(T p_102857_) {
        HumanoidArm humanoidarm = p_102857_.getMainArm();
        return ((LivingEntity)p_102857_).swingingArm == InteractionHand.MAIN_HAND ? humanoidarm : humanoidarm.getOpposite();
    }
}

