/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.protect_your_moa.client.renderer.entity.layers;

import com.aetherteam.aether.client.renderer.entity.model.MoaModel;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.protect_your_moa.attachment.MoaArmorAttachment;
import com.aetherteam.protect_your_moa.attachment.ProtectDataAttachments;
import com.aetherteam.protect_your_moa.client.renderer.entity.ProtectModelLayers;
import com.aetherteam.protect_your_moa.item.combat.DyeableMoaArmorItem;
import com.aetherteam.protect_your_moa.item.combat.MoaArmorItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class MoaArmorLayer
extends RenderLayer<Moa, MoaModel> {
    private final MoaModel model;

    public MoaArmorLayer(RenderLayerParent<Moa, MoaModel> renderer, EntityModelSet modelSet) {
        super(renderer);
        this.model = new MoaModel(modelSet.bakeLayer(ProtectModelLayers.MOA_ARMOR));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Moa moa, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        Item item;
        ItemStack itemStack = ((MoaArmorAttachment)moa.getData(ProtectDataAttachments.MOA_ARMOR)).getArmor();
        if (itemStack != null && !itemStack.isEmpty() && (item = itemStack.getItem()) instanceof MoaArmorItem) {
            MoaArmorItem moaArmorItem = (MoaArmorItem)item;
            ((MoaModel)this.getParentModel()).copyPropertiesTo((EntityModel)this.model);
            this.model.prepareMobModel(moa, limbSwing, limbSwingAmount, partialTick);
            this.model.setupAnim(moa, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            int color = FastColor.ARGB32.opaque((int)IClientItemExtensions.of((ItemStack)itemStack).getDefaultDyeColor(itemStack));
            Item item2 = itemStack.getItem();
            if (item2 instanceof DyeableMoaArmorItem) {
                DyeableMoaArmorItem dyeableMoaArmorItem = (DyeableMoaArmorItem)item2;
                if (color != 0) {
                    VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)dyeableMoaArmorItem.getOverlayTexture()));
                    this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
                }
            }
            VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)moaArmorItem.getTexture()));
            this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        }
    }
}

