/*
 * Decompiled with CFR 0.152.
 */
package dev.jaronline.cuttingdelight.data;

import dev.jaronline.cuttingdelight.CuttingDelight;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModels
extends ItemModelProvider {
    public static final String GENERATED = "item/generated";

    public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "cuttingdelight", existingFileHelper);
    }

    protected void registerModels() {
        Set<Item> items = BuiltInRegistries.ITEM.stream().filter(i -> "cuttingdelight".equals(BuiltInRegistries.ITEM.getKey(i).getNamespace())).collect(Collectors.toSet());
        ItemModels.takeAll(items, i -> i instanceof BlockItem).forEach(item -> this.blockBasedModel((Item)item, ""));
        items.forEach(item -> this.itemGeneratedModel((Item)item, this.resourceItem(this.itemName((Item)item))));
    }

    public void blockBasedModel(Item item, String suffix) {
        this.withExistingParent(this.itemName(item), this.resourceBlock(this.itemName(item) + suffix));
    }

    public void itemGeneratedModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), GENERATED)).texture("layer0", texture);
    }

    private String itemName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    public ResourceLocation resourceBlock(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"cuttingdelight", (String)("block/" + path));
    }

    public ResourceLocation resourceItem(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"cuttingdelight", (String)("item/" + path));
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            CuttingDelight.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            CuttingDelight.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            CuttingDelight.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }
}

