/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.entity;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import vectorwing.farmersdelight.common.registry.ModEntityTypes;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModSounds;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RottenTomatoEntity
extends ThrowableItemProjectile {
    public RottenTomatoEntity(EntityType<? extends RottenTomatoEntity> entityType, Level level) {
        super(entityType, level);
    }

    public RottenTomatoEntity(Level level, LivingEntity entity) {
        super(ModEntityTypes.ROTTEN_TOMATO.get(), entity, level);
    }

    public RottenTomatoEntity(Level level, double x, double y, double z) {
        super(ModEntityTypes.ROTTEN_TOMATO.get(), x, y, z, level);
    }

    protected Item getDefaultItem() {
        return ModItems.ROTTEN_TOMATO.get();
    }

    public void handleEntityEvent(byte id) {
        ItemStack entityStack = new ItemStack((ItemLike)this.getDefaultItem());
        if (id == 3) {
            ItemParticleOption iparticledata = new ItemParticleOption(ParticleTypes.ITEM, entityStack);
            for (int i = 0; i < 12; ++i) {
                this.level().addParticle((ParticleOptions)iparticledata, this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f, ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f + (double)0.1f, ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
        this.playSound(ModSounds.ENTITY_ROTTEN_TOMATO_HIT.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.playSound(ModSounds.ENTITY_ROTTEN_TOMATO_HIT.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.discard();
        }
    }
}

