/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.serializer;

import com.aetherteam.aether.recipe.AetherBookCategory;
import com.aetherteam.aether.recipe.recipes.item.AbstractAetherCookingRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class AetherCookingSerializer<T extends AbstractAetherCookingRecipe>
implements RecipeSerializer<T> {
    private final CookieBaker<T> factory;
    private final MapCodec<T> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

    public AetherCookingSerializer(CookieBaker<T> factory, int defaultCookingTime) {
        this.factory = factory;
        this.codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(AbstractCookingRecipe::getGroup), (App)AetherBookCategory.CODEC.fieldOf("category").forGetter(AbstractAetherCookingRecipe::aetherCategory), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> (Ingredient)recipe.getIngredients().getFirst()), (App)ItemStack.CODEC.fieldOf("result").forGetter(AbstractAetherCookingRecipe::getResult), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(AbstractCookingRecipe::getExperience), (App)Codec.INT.fieldOf("cookingtime").orElse((Object)defaultCookingTime).forGetter(AbstractCookingRecipe::getCookingTime)).apply((Applicative)instance, factory::create));
        this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    public MapCodec<T> codec() {
        return this.codec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    public T fromNetwork(RegistryFriendlyByteBuf buffer) {
        String group = buffer.readUtf();
        AetherBookCategory aetherBookCategory = (AetherBookCategory)buffer.readEnum(AetherBookCategory.class);
        Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        float experience = buffer.readFloat();
        int cookingTime = buffer.readVarInt();
        return this.factory.create(group, aetherBookCategory, ingredient, result, experience, cookingTime);
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer, T recipe) {
        buffer.writeUtf(recipe.getGroup());
        buffer.writeEnum((Enum)Objects.requireNonNullElse(((AbstractAetherCookingRecipe)((Object)recipe)).aetherCategory(), AetherBookCategory.UNKNOWN));
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)((Ingredient)recipe.getIngredients().getFirst()));
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)((AbstractAetherCookingRecipe)((Object)recipe)).getResult());
        buffer.writeFloat(recipe.getExperience());
        buffer.writeVarInt(recipe.getCookingTime());
    }

    public static interface CookieBaker<T extends AbstractAetherCookingRecipe> {
        public T create(String var1, AetherBookCategory var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

