/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.accessories.abilities;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.nitrogen.ConstantsUtil;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;

public interface ShieldOfRepulsionAccessory {
    public static void deflectProjectile(ProjectileImpactEvent event, HitResult hitResult, Projectile projectile) {
        EntityHitResult entityHitResult;
        Entity entity;
        if (hitResult.getType() == HitResult.Type.ENTITY && hitResult instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)hitResult).getEntity()) instanceof LivingEntity) {
            SlotEntryReference slotResult;
            LivingEntity impactedLiving = (LivingEntity)entity;
            if (projectile.getType().is(AetherTags.Entities.DEFLECTABLE_PROJECTILES) && (slotResult = EquipmentUtil.getAccessory(impactedLiving, (Item)AetherItems.SHIELD_OF_REPULSION.get())) != null) {
                Vec3 motion = impactedLiving.getDeltaMovement();
                if (impactedLiving instanceof Player) {
                    Player player = (Player)impactedLiving;
                    AetherPlayerAttachment data = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
                    if (!data.isMoving() || data.isMoving() && motion.x() == 0.0 && (motion.y() == ConstantsUtil.DEFAULT_DELTA_MOVEMENT_Y || motion.y() == 0.0) && motion.z() == 0.0) {
                        if (player.level().isClientSide()) {
                            data.setProjectileImpactedMaximum(150);
                            data.setProjectileImpactedTimer(150);
                        }
                        ShieldOfRepulsionAccessory.handleDeflection(event, projectile, (LivingEntity)player, slotResult);
                    }
                } else if (motion.x() == 0.0 && (motion.y() == ConstantsUtil.DEFAULT_DELTA_MOVEMENT_Y || motion.y() == 0.0) && motion.z() == 0.0) {
                    ShieldOfRepulsionAccessory.handleDeflection(event, projectile, impactedLiving, slotResult);
                }
            }
        }
    }

    private static void handleDeflection(ProjectileImpactEvent event, Projectile projectile, LivingEntity impactedLiving, SlotEntryReference slotResult) {
        event.setCanceled(true);
        if (!impactedLiving.equals((Object)projectile.getOwner())) {
            projectile.deflect(ProjectileDeflection.REVERSE, (Entity)impactedLiving, projectile.getOwner(), false);
            projectile.setDeltaMovement(projectile.getDeltaMovement().scale(0.25));
            Level level = impactedLiving.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                slotResult.stack().hurtAndBreak(1, serverLevel, impactedLiving, item -> AccessoriesAPI.breakStack((SlotReference)slotResult.reference()));
            }
        }
    }
}

