/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.command;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.command.SunAltarWhitelist;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.server.players.UserWhiteListEntry;

public class SunAltarWhitelistCommand {
    private static final SimpleCommandExceptionType ERROR_ALREADY_ENABLED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.aether.sun_altar_whitelist.alreadyOn"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_DISABLED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.aether.sun_altar_whitelist.alreadyOff"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_WHITELISTED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.aether.sun_altar_whitelist.add.failed"));
    private static final SimpleCommandExceptionType ERROR_NOT_WHITELISTED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.aether.sun_altar_whitelist.remove.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"aether").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sun_altar_whitelist").requires(commandSourceStack -> commandSourceStack.hasPermission(4))).then(Commands.literal((String)"on").executes(context -> SunAltarWhitelistCommand.enableWhitelist((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"off").executes(context -> SunAltarWhitelistCommand.disableWhitelist((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"list").executes(context -> SunAltarWhitelistCommand.showList((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"add").then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).suggests((context, builder) -> {
            PlayerList playerlist = ((CommandSourceStack)context.getSource()).getServer().getPlayerList();
            return SharedSuggestionProvider.suggest(playerlist.getPlayers().stream().filter(serverPlayer -> !playerlist.getWhiteList().isWhiteListed(serverPlayer.getGameProfile())).map(player -> player.getGameProfile().getName()), (SuggestionsBuilder)builder);
        }).executes(context -> SunAltarWhitelistCommand.addPlayers((CommandSourceStack)context.getSource(), GameProfileArgument.getGameProfiles((CommandContext)context, (String)"targets")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).suggests((context, builder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)context.getSource()).getServer().getPlayerList().getWhiteListNames(), (SuggestionsBuilder)builder)).executes(context -> SunAltarWhitelistCommand.removePlayers((CommandSourceStack)context.getSource(), GameProfileArgument.getGameProfiles((CommandContext)context, (String)"targets")))))).then(Commands.literal((String)"reload").executes(context -> SunAltarWhitelistCommand.reload((CommandSourceStack)context.getSource())))));
    }

    private static int reload(CommandSourceStack source) {
        SunAltarWhitelist.INSTANCE.reload();
        source.sendSuccess(() -> Component.translatable((String)"commands.aether.sun_altar_whitelist.reloaded"), true);
        return 1;
    }

    private static int addPlayers(CommandSourceStack source, Collection<GameProfile> players) throws CommandSyntaxException {
        UserWhiteList sunAltarWhiteList = SunAltarWhitelist.INSTANCE.getSunAltarWhiteList();
        int i = 0;
        for (GameProfile gameProfile : players) {
            if (sunAltarWhiteList.isWhiteListed(gameProfile)) continue;
            UserWhiteListEntry entry = new UserWhiteListEntry(gameProfile);
            sunAltarWhiteList.add((StoredUserEntry)entry);
            source.sendSuccess(() -> Component.translatable((String)"commands.aether.sun_altar_whitelist.add.success", (Object[])new Object[]{Component.literal((String)gameProfile.getName())}), true);
            ++i;
        }
        if (i == 0) {
            throw ERROR_ALREADY_WHITELISTED.create();
        }
        return i;
    }

    private static int removePlayers(CommandSourceStack source, Collection<GameProfile> players) throws CommandSyntaxException {
        UserWhiteList sunAltarWhiteList = SunAltarWhitelist.INSTANCE.getSunAltarWhiteList();
        int i = 0;
        for (GameProfile gameProfile : players) {
            if (!sunAltarWhiteList.isWhiteListed(gameProfile)) continue;
            UserWhiteListEntry userwhitelistentry = new UserWhiteListEntry(gameProfile);
            sunAltarWhiteList.remove((StoredUserEntry)userwhitelistentry);
            source.sendSuccess(() -> Component.translatable((String)"commands.aether.sun_altar_whitelist.remove.success", (Object[])new Object[]{Component.literal((String)gameProfile.getName())}), true);
            ++i;
        }
        if (i == 0) {
            throw ERROR_NOT_WHITELISTED.create();
        }
        source.getServer().kickUnlistedPlayers(source);
        return i;
    }

    private static int enableWhitelist(CommandSourceStack source) throws CommandSyntaxException {
        if (((Boolean)AetherConfig.SERVER.sun_altar_whitelist.get()).booleanValue()) {
            throw ERROR_ALREADY_ENABLED.create();
        }
        AetherConfig.SERVER.sun_altar_whitelist.set((Object)true);
        AetherConfig.SERVER.sun_altar_whitelist.save();
        source.sendSuccess(() -> Component.translatable((String)"commands.aether.sun_altar_whitelist.enabled"), true);
        return 1;
    }

    private static int disableWhitelist(CommandSourceStack source) throws CommandSyntaxException {
        if (!((Boolean)AetherConfig.SERVER.sun_altar_whitelist.get()).booleanValue()) {
            throw ERROR_ALREADY_DISABLED.create();
        }
        AetherConfig.SERVER.sun_altar_whitelist.set((Object)false);
        AetherConfig.SERVER.sun_altar_whitelist.save();
        source.sendSuccess(() -> Component.translatable((String)"commands.aether.sun_altar_whitelist.disabled"), true);
        return 1;
    }

    private static int showList(CommandSourceStack source) {
        String[] names = SunAltarWhitelist.INSTANCE.getSunAltarWhiteListNames();
        if (names.length == 0) {
            source.sendSuccess(() -> Component.translatable((String)"commands.aether.sun_altar_whitelist.none"), false);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.aether.sun_altar_whitelist.list", (Object[])new Object[]{names.length, String.join((CharSequence)", ", names)}), false);
        }
        return names.length;
    }
}

