/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.player.layer;

import com.aetherteam.aether.client.gui.screen.perks.AetherCustomizationsScreen;
import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.aetherteam.aether.client.renderer.entity.model.HaloModel;
import com.aetherteam.aether.perk.PerkUtil;
import com.aetherteam.aether.perk.data.ClientHaloPerkData;
import com.aetherteam.aether.perk.types.Halo;
import com.aetherteam.nitrogen.api.users.User;
import com.aetherteam.nitrogen.api.users.UserData;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Triple;

public class PlayerHaloLayer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation PLAYER_HALO_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/models/perks/halo.png");
    private static final ResourceLocation PLAYER_HALO_GRAYSCALE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/models/perks/halo_grayscale.png");
    private final HaloModel<Player> playerHalo;

    public PlayerHaloLayer(RenderLayerParent<T, M> entityRenderer, EntityModelSet modelSet) {
        super(entityRenderer);
        this.playerHalo = new HaloModel(modelSet.bakeLayer(AetherModelLayers.PLAYER_HALO));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        block7: {
            Triple<Float, Float, Float> color;
            Map halos;
            UUID playerUUID;
            block9: {
                block8: {
                    AbstractClientPlayer abstractClientPlayer;
                    if (!(entity instanceof AbstractClientPlayer) || (abstractClientPlayer = (AbstractClientPlayer)entity).isInvisible()) break block7;
                    User user = UserData.Client.getClientUser();
                    playerUUID = abstractClientPlayer.getUUID();
                    halos = ClientHaloPerkData.INSTANCE.getClientPerkData();
                    Screen screen = Minecraft.getInstance().screen;
                    if (!(screen instanceof AetherCustomizationsScreen)) break block8;
                    AetherCustomizationsScreen aetherCustomizationsScreen = (AetherCustomizationsScreen)screen;
                    if (aetherCustomizationsScreen.haloEnabled && Minecraft.getInstance().player != null && playerUUID.equals(Minecraft.getInstance().player.getUUID()) && user != null && PerkUtil.hasHalo().test(user)) break block9;
                }
                if (Minecraft.getInstance().screen instanceof AetherCustomizationsScreen || !halos.containsKey(playerUUID)) break block7;
            }
            this.playerHalo.halo.yRot = ((PlayerModel)this.getParentModel()).head.yRot;
            this.playerHalo.halo.xRot = ((PlayerModel)this.getParentModel()).head.xRot;
            this.playerHalo.halo.y = entity.isCrouching() ? 4.2f : 0.0f;
            this.playerHalo.setupAnim((Player)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof AetherCustomizationsScreen) {
                AetherCustomizationsScreen aetherCustomizationsScreen = (AetherCustomizationsScreen)screen;
                color = PerkUtil.getPerkColor(aetherCustomizationsScreen.haloColor);
            } else {
                color = PerkUtil.getPerkColor(((Halo)halos.get(playerUUID)).hexColor());
            }
            if (color != null) {
                vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)PLAYER_HALO_GRAYSCALE_LOCATION));
                this.playerHalo.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, new Color(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).getRGB());
            } else {
                vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)PLAYER_HALO_LOCATION));
                this.playerHalo.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
            }
        }
    }
}

