/*
 * Decompiled with CFR 0.152.
 */
package com.cake.trading_floor.content.trading_depot.behavior;

import com.cake.trading_floor.content.trading_depot.TradingDepotItemHandler;
import com.cake.trading_floor.foundation.TFLang;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;

public class TradingDepotBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<TradingDepotBehaviour> TYPE = new BehaviourType();
    public FilteringBehaviour filtering;
    final TradingDepotItemHandler itemHandler = new TradingDepotItemHandler(this);
    TransportedItemStack offer;
    List<ItemStack> result = new ArrayList<ItemStack>();
    List<TransportedItemStack> incoming = new ArrayList<TransportedItemStack>();
    VersionedInventoryTrackerBehaviour invVersionTracker;
    boolean pruneEmptyStacksNextTick = false;

    public TradingDepotBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public void tick() {
        super.tick();
        Level world = this.blockEntity.getLevel();
        if (world == null) {
            return;
        }
        if (this.pruneEmptyStacksNextTick) {
            this.result = new ArrayList<ItemStack>(this.result.stream().filter(stack -> !stack.isEmpty()).toList());
            this.pruneEmptyStacksNextTick = false;
        }
        Iterator<TransportedItemStack> iterator = this.incoming.iterator();
        while (iterator.hasNext()) {
            TransportedItemStack ts = iterator.next();
            if (!this.tick(ts) || world.isClientSide && !this.blockEntity.isVirtual()) continue;
            if (this.offer == null) {
                this.offer = ts;
            } else if (!ItemHelper.canItemStackAmountsStack((ItemStack)this.offer.stack, (ItemStack)ts.stack)) {
                Vec3 vec = VecHelper.getCenterOf((Vec3i)this.blockEntity.getBlockPos());
                Containers.dropItemStack((Level)this.blockEntity.getLevel(), (double)vec.x, (double)(vec.y + 0.5), (double)vec.z, (ItemStack)ts.stack);
            } else {
                this.offer.stack.grow(ts.stack.getCount());
            }
            iterator.remove();
            this.blockEntity.notifyUpdate();
        }
        if (this.offer == null) {
            return;
        }
        this.tick(this.offer);
    }

    public void doPruneEmptyStacksNextTick() {
        this.pruneEmptyStacksNextTick = true;
    }

    protected boolean tick(TransportedItemStack input) {
        input.prevBeltPosition = input.beltPosition;
        input.prevSideOffset = input.sideOffset;
        float diff = 0.5f - input.beltPosition;
        if (diff > 0.001953125f) {
            if (diff > 0.03125f && !BeltHelper.isItemUpright((ItemStack)input.stack)) {
                ++input.angle;
            }
            input.beltPosition += diff / 4.0f;
        }
        return diff < 0.0625f;
    }

    public void addAdditionalBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour(this.blockEntity).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this.blockEntity);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        ItemStack inserted = transportedStack.stack;
        int size = transportedStack.stack.getCount();
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = side.getAxis().isVertical() ? 0.5f : 0.0f;
        transportedStack.insertedFrom = side;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        ItemStack remainder = this.insert(transportedStack, simulate);
        if (remainder.getCount() != size) {
            this.blockEntity.notifyUpdate();
        }
        return remainder;
    }

    public int getPresentStackSize() {
        int cumulativeStackSize = 0;
        cumulativeStackSize += this.getOfferStack().getCount();
        for (TransportedItemStack transportedItemStack : this.incoming) {
            cumulativeStackSize += transportedItemStack.stack.getCount();
        }
        return cumulativeStackSize;
    }

    public int getRemainingSpace() {
        int cumulativeStackSize = this.getPresentStackSize();
        return this.getOfferStack().getMaxStackSize() - cumulativeStackSize;
    }

    public ItemStack insert(TransportedItemStack input, boolean simulate) {
        boolean canCombine;
        int remainingSpace = this.getRemainingSpace();
        ItemStack inserted = input.stack;
        if (remainingSpace <= 0) {
            return inserted;
        }
        boolean offerNull = this.offer == null;
        boolean offerEmpty = !offerNull && this.offer.stack.isEmpty();
        boolean bl = canCombine = offerNull || offerEmpty || ItemStack.isSameItemSameComponents((ItemStack)this.offer.stack, (ItemStack)inserted);
        if (!canCombine) {
            return inserted;
        }
        ItemStack returned = ItemStack.EMPTY;
        if (remainingSpace < inserted.getCount()) {
            returned = input.stack.copyWithCount(inserted.getCount() - remainingSpace);
            if (!simulate) {
                TransportedItemStack copy = input.copy();
                copy.stack.setCount(remainingSpace);
                if (this.offer != null && !this.offer.stack.isEmpty()) {
                    this.incoming.add(copy);
                } else {
                    this.offer = copy;
                }
            }
        } else if (!simulate) {
            if (this.offer != null && !this.offer.stack.isEmpty()) {
                this.incoming.add(input);
            } else {
                this.offer = input;
            }
        }
        return returned;
    }

    public boolean isEmpty() {
        return this.offer == null && this.isOutputEmpty();
    }

    public boolean isOutputEmpty() {
        for (ItemStack stack : this.result) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void destroy() {
        super.destroy();
        Level level = this.getWorld();
        BlockPos pos = this.getPos();
        ItemHelper.dropContents((Level)level, (BlockPos)pos, (IItemHandler)this.itemHandler);
        for (TransportedItemStack transportedItemStack : this.incoming) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)transportedItemStack.stack);
        }
    }

    public void unload() {
        if (this.itemHandler != null) {
            this.blockEntity.invalidateCapabilities();
        }
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        this.offer = null;
        if (nbt.contains("Input")) {
            this.offer = TransportedItemStack.read((CompoundTag)nbt.getCompound("Input"), (HolderLookup.Provider)registries);
        }
        int outputCount = nbt.getInt("OutputCount");
        this.result = new ArrayList<ItemStack>(outputCount);
        for (int i = 0; i < outputCount; ++i) {
            this.result.add(ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("Output" + i)));
        }
        ListTag list = nbt.getList("Incoming", 10);
        this.incoming = NBTHelper.readCompoundList((ListTag)list, c -> TransportedItemStack.read((CompoundTag)c, (HolderLookup.Provider)registries));
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.offer != null) {
            nbt.put("Input", (Tag)this.offer.serializeNBT(registries));
        }
        nbt.putInt("OutputCount", this.result.size());
        for (int i = 0; i < this.result.size(); ++i) {
            nbt.put("Output" + i, this.result.get(i).saveOptional(registries));
        }
        if (!this.incoming.isEmpty()) {
            nbt.put("Incoming", (Tag)NBTHelper.writeCompoundList(this.incoming, stack -> stack.serializeNBT(registries)));
        }
    }

    public ItemStack getOfferStack() {
        return this.offer == null ? ItemStack.EMPTY : this.offer.stack;
    }

    public void setOfferStack(TransportedItemStack input) {
        this.offer = input;
    }

    public void setOfferStack(ItemStack input) {
        if (this.offer != null) {
            this.offer.stack = input;
        } else {
            this.offer = new TransportedItemStack(input);
        }
    }

    public void removeOfferStack() {
        this.offer = null;
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void combineOutputs() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : this.result) {
            for (ItemStack other : result) {
                if (!ItemHelper.canItemStackAmountsStack((ItemStack)stack, (ItemStack)other)) continue;
                int newCount = Math.min(other.getCount() + stack.getCount(), other.getMaxStackSize());
                int filledCount = newCount - other.getCount();
                other.setCount(newCount);
                stack.setCount(stack.getCount() - filledCount);
            }
            if (stack.isEmpty()) continue;
            result.add(stack);
        }
        this.result = result;
    }

    public boolean canBeUsedFor(MerchantOffer offer) {
        return this.filtering.test(offer.getResult());
    }

    public void addContentsToTooltip(List<Component> tooltip) {
        TFLang.translate("tooltip.trading_depot.contents", new Object[0]).forGoggles(tooltip);
        if (this.offer != null && !this.offer.stack.isEmpty()) {
            TFLang.translate("tooltip.trading_depot.contents.input", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            TFLang.itemStack(this.offer.stack).style(ChatFormatting.GRAY).forGoggles(tooltip, 2);
        }
        if (!this.result.isEmpty()) {
            TFLang.translate("tooltip.trading_depot.contents.output", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            for (ItemStack stack : this.result) {
                TFLang.itemStack(stack).style(ChatFormatting.GRAY).forGoggles(tooltip, 2);
            }
        }
    }

    public List<ItemStack> getResults() {
        return this.result;
    }

    public void resetInv() {
        this.invVersionTracker.reset();
    }

    public TransportedItemStack getOffer() {
        return this.offer;
    }

    public List<TransportedItemStack> getIncoming() {
        return this.incoming;
    }

    public TradingDepotItemHandler getRealItemHandler() {
        return this.itemHandler;
    }

    public void spinOfferOrSomething() {
        this.offer.angle = this.offer.angle + (int)((Math.random() * 10.0 + 10.0) * (double)(Math.random() > 0.5 ? -1 : 1));
    }
}

