/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.block.mechanicalfryer;

import com.pyzpre.createbitterballen.block.mechanicalfryer.DeepFryingRecipe;
import com.pyzpre.createbitterballen.block.mechanicalfryer.FryerOperatingBlockEntity;
import com.pyzpre.createbitterballen.index.BlockEntityRegistry;
import com.pyzpre.createbitterballen.index.RecipeRegistry;
import com.pyzpre.createbitterballen.index.SoundsRegistry;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class MechanicalFryerEntity
extends FryerOperatingBlockEntity {
    private static final Object DeepFryingRecipesKey = new Object();
    private boolean shouldRecalculateProcessingTicks = true;
    public SmartInventory inputInv = new SmartInventory(1, (SyncedBlockEntity)this);
    public SmartInventory outputInv = new SmartInventory(9, (SyncedBlockEntity)this);
    public int timer;
    private DeepFryingRecipe lastRecipe;
    public int runningTicks;
    public int processingTicks;
    public boolean running;
    private final FryerInventoryHandler inventoryHandler = new FryerInventoryHandler(this.inputInv, this.outputInv);

    public MechanicalFryerEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        super.addBehaviours(behaviours);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        float offset = 0.0f;
        if (this.running && this.speed != 0.0f) {
            if (this.runningTicks < 20) {
                int localTick = this.runningTicks;
                float num = ((float)localTick + partialTicks) / 20.0f;
                num = (2.0f - Mth.cos((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            } else if (this.runningTicks <= 20) {
                offset = 1.0f;
            } else {
                int localTick = 40 - this.runningTicks;
                float num = ((float)localTick - partialTicks) / 20.0f;
                num = (2.0f - Mth.cos((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            }
        }
        return offset + 0.4375f;
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).expandTowards(0.0, -1.5, 0.0);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.running = compound.getBoolean("Running");
        this.runningTicks = compound.getInt("Ticks");
        this.timer = compound.getInt("Timer");
        this.inputInv.deserializeNBT(registries, compound.getCompound("InputInventory"));
        this.outputInv.deserializeNBT(registries, compound.getCompound("OutputInventory"));
        this.shouldRecalculateProcessingTicks = compound.getBoolean("ShouldRecalculate");
        super.read(compound, registries, clientPacket);
        if (clientPacket && this.hasLevel()) {
            this.getBasin().ifPresent(bte -> bte.setAreFluidsMoving(this.running && this.runningTicks <= 20));
        }
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putBoolean("Running", this.running);
        compound.putInt("Ticks", this.runningTicks);
        compound.putInt("Timer", this.timer);
        compound.put("InputInventory", (Tag)this.inputInv.serializeNBT(registries));
        compound.put("OutputInventory", (Tag)this.outputInv.serializeNBT(registries));
        compound.putBoolean("ShouldRecalculate", this.shouldRecalculateProcessingTicks);
        super.write(compound, registries, clientPacket);
    }

    private boolean applyRecipe(DeepFryingRecipe recipe) {
        Optional<BasinBlockEntity> basinOpt = this.getBasin();
        if (basinOpt.isEmpty()) {
            return false;
        }
        BasinBlockEntity basin = basinOpt.get();
        IFluidHandler fluidHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, basin.getBlockPos(), null);
        if (fluidHandler == null) {
            return false;
        }
        int maxProcessableItems = this.inputInv.getStackInSlot(0).getCount();
        for (SizedFluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            int requiredAmount = fluidIngredient.amount();
            int totalMatchingAmount = 0;
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                FluidStack fluidInTank = fluidHandler.getFluidInTank(tank);
                if (!fluidIngredient.test(fluidInTank)) continue;
                totalMatchingAmount += fluidInTank.getAmount();
            }
            maxProcessableItems = Math.min(maxProcessableItems, totalMatchingAmount / requiredAmount);
        }
        if (recipe instanceof BasinRecipe) {
            DeepFryingRecipe basinRecipe = recipe;
            IFluidHandler basinFluidHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, basin.getBlockPos(), null);
            if (basinFluidHandler == null) {
                return false;
            }
            for (FluidStack fluidResult : basinRecipe.getFluidResults()) {
                int perItem = fluidResult.getAmount();
                int best = 0;
                for (int i = maxProcessableItems; i >= 1; --i) {
                    FluidStack scaled = fluidResult.copy();
                    scaled.setAmount(perItem * i);
                    int fill = basinFluidHandler.fill(scaled, IFluidHandler.FluidAction.SIMULATE);
                    if (fill < scaled.getAmount()) continue;
                    best = i;
                    break;
                }
                if ((maxProcessableItems = Math.min(maxProcessableItems, best)) != 0) continue;
                return false;
            }
        }
        if (maxProcessableItems <= 0) {
            return false;
        }
        for (SizedFluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            int drainedAmount;
            FluidStack fluidInTank;
            int amountToConsume = fluidIngredient.amount() * maxProcessableItems;
            for (int tank = 0; !(tank >= fluidHandler.getTanks() || fluidIngredient.test(fluidInTank = fluidHandler.getFluidInTank(tank)) && (amountToConsume -= (drainedAmount = fluidHandler.drain(fluidInTank.copyWithAmount(amountToConsume), IFluidHandler.FluidAction.EXECUTE).getAmount())) <= 0); ++tank) {
            }
        }
        ItemStack inputStack = this.inputInv.getStackInSlot(0);
        inputStack.shrink(maxProcessableItems);
        this.inputInv.setStackInSlot(0, inputStack);
        List outputs = recipe.rollResults(this.level.random);
        for (ItemStack output : outputs) {
            output.setCount(output.getCount() * maxProcessableItems);
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)output.copy(), (boolean)false);
            if (remaining.isEmpty()) continue;
            return false;
        }
        if (recipe instanceof BasinRecipe) {
            DeepFryingRecipe basinRecipe = recipe;
            NonNullList fluidResults = basinRecipe.getFluidResults();
            for (FluidStack fluidResult : fluidResults) {
                FluidStack outputFluidStack = fluidResult.copy();
                outputFluidStack.setAmount(outputFluidStack.getAmount() * maxProcessableItems);
                IFluidHandler basinFluidHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, basin.getBlockPos(), null);
                if (basinFluidHandler == null) {
                    return false;
                }
                int filled = basinFluidHandler.fill(outputFluidStack, IFluidHandler.FluidAction.EXECUTE);
                if (filled >= outputFluidStack.getAmount()) continue;
                return false;
            }
        }
        basin.setChanged();
        basin.sendData();
        this.sendData();
        this.setChanged();
        return true;
    }

    public void tick() {
        if (this.basinRemoved) {
            this.basinRemoved = false;
            this.onBasinRemoved();
            this.sendData();
            return;
        }
        super.tick();
        float speed = Math.abs(this.getSpeed());
        boolean canStartProcessing = this.hasMatchingRecipe();
        float recipeSpeed = 1.0f;
        if (this.getSpeed() == 0.0f && this.running) {
            this.resetAnimationAndProcessing();
        }
        if (!this.running && canStartProcessing) {
            this.running = true;
            this.runningTicks = 0;
            this.shouldRecalculateProcessingTicks = true;
        }
        if (this.running) {
            if (this.processingTicks > 0) {
                if (this.runningTicks < 20) {
                    ++this.runningTicks;
                }
                --this.processingTicks;
            } else if (this.runningTicks < 40) {
                ++this.runningTicks;
            } else if (!canStartProcessing) {
                this.running = false;
                this.runningTicks = 0;
                this.shouldRecalculateProcessingTicks = false;
            } else {
                this.shouldRecalculateProcessingTicks = true;
                this.runningTicks = 0;
            }
            if (this.runningTicks == 20 && this.processingTicks == 1) {
                for (int slot = 0; slot < this.inputInv.getSlots(); ++slot) {
                    ItemStack stackInSlot = this.inputInv.getStackInSlot(slot);
                    if (!this.isIce(stackInSlot)) continue;
                    this.causeExplosion();
                    this.inputInv.setStackInSlot(slot, ItemStack.EMPTY);
                    break;
                }
            }
            if (this.runningTicks == 20) {
                if (this.processingTicks == 1) {
                    if (this.lastRecipe == null || !this.matchesRecipe(this.lastRecipe)) {
                        Optional<DeepFryingRecipe> recipeOpt = this.findMatchingRecipe(this.level);
                        this.lastRecipe = recipeOpt.orElse(null);
                        if (this.lastRecipe != null) {
                            // empty if block
                        }
                    }
                    if (this.lastRecipe == null || this.applyRecipe(this.lastRecipe)) {
                        // empty if block
                    }
                }
                if (this.runningTicks == 20 && this.shouldRecalculateProcessingTicks && canStartProcessing) {
                    int duration;
                    if (this.lastRecipe != null && (duration = this.lastRecipe.getProcessingDuration()) != 0) {
                        recipeSpeed = (float)duration / 100.0f;
                    }
                    this.processingTicks = Mth.clamp((int)(Mth.log2((int)((int)(512.0f / speed))) * Mth.ceil((float)(recipeSpeed * 15.0f)) + 1), (int)1, (int)512);
                    this.shouldRecalculateProcessingTicks = false;
                }
            }
        }
    }

    private boolean isIce(ItemStack stack) {
        ResourceLocation iceTag = ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ice");
        return stack.is(ItemTags.create((ResourceLocation)iceTag));
    }

    private void resetAnimationAndProcessing() {
        this.running = false;
        this.processingTicks = 0;
        this.runningTicks = 0;
    }

    private static void grantAdvancementCriterion(ServerPlayer player, String advancementID, String criterionKey) {
        PlayerAdvancements playerAdvancements = player.getAdvancements();
        ResourceLocation id = ResourceLocation.parse((String)advancementID);
        Optional.ofNullable(player.server.getAdvancements().get(id)).ifPresent(holder -> {
            AdvancementProgress progress;
            if (holder.value().criteria().containsKey(criterionKey) && !(progress = playerAdvancements.getOrStartProgress(holder)).isDone()) {
                playerAdvancements.award(holder, criterionKey);
            }
        });
    }

    private void causeExplosion() {
        if (!this.level.isClientSide()) {
            this.level.explode(null, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, 4.0f, false, Level.ExplosionInteraction.MOB);
            double radius = 10.0;
            AABB area = new AABB(this.worldPosition).inflate(radius);
            List players = this.level.getEntitiesOfClass(ServerPlayer.class, area);
            for (ServerPlayer player : players) {
                MechanicalFryerEntity.grantAdvancementCriterion(player, "create_bic_bit:fry_about_it", "ice_exploded");
            }
        }
    }

    private boolean hasMatchingRecipe() {
        if (this.inputInv.getStackInSlot(0).isEmpty()) {
            this.currentRecipe = null;
            return false;
        }
        Optional<DeepFryingRecipe> recipeOpt = this.findMatchingRecipe(this.level);
        if (recipeOpt.isEmpty()) {
            this.currentRecipe = null;
            return false;
        }
        DeepFryingRecipe recipe = recipeOpt.get();
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!this.isBlazeBurnerConfigured(requiredHeat)) {
            this.currentRecipe = null;
            return false;
        }
        if (recipe instanceof BasinRecipe) {
            int inputCount;
            DeepFryingRecipe basinRecipe = recipe;
            Optional<BasinBlockEntity> basinOpt = this.getBasin();
            if (basinOpt.isEmpty()) {
                this.currentRecipe = null;
                return false;
            }
            IFluidHandler fluidHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, basinOpt.get().getBlockPos(), null);
            if (fluidHandler == null) {
                this.currentRecipe = null;
                return false;
            }
            int maxProcessable = inputCount = this.inputInv.getStackInSlot(0).getCount();
            for (FluidStack fluidResult : basinRecipe.getFluidResults()) {
                int amountPerItem = fluidResult.getAmount();
                int maxForThisFluid = 0;
                for (int i = inputCount; i >= 1; --i) {
                    FluidStack simulated = fluidResult.copy();
                    simulated.setAmount(amountPerItem * i);
                    int fill = fluidHandler.fill(simulated, IFluidHandler.FluidAction.SIMULATE);
                    if (fill < simulated.getAmount()) continue;
                    maxForThisFluid = i;
                    break;
                }
                if ((maxProcessable = Math.min(maxProcessable, maxForThisFluid)) != 0) continue;
                this.currentRecipe = null;
                return false;
            }
        }
        this.currentRecipe = recipe;
        return true;
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inputInv);
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.outputInv);
    }

    private boolean isBlazeBurnerConfigured(HeatCondition requiredHeat) {
        if (requiredHeat == HeatCondition.NONE) {
            return true;
        }
        if (this.level == null) {
            return false;
        }
        BlockPos posBelowBasin = this.worldPosition.below(3);
        BlockState blockStateBelow = this.level.getBlockState(posBelowBasin);
        BlazeBurnerBlock.HeatLevel actualHeat = BasinBlockEntity.getHeatLevelOf((BlockState)blockStateBelow);
        return requiredHeat.testBlazeBurner(actualHeat);
    }

    private Optional<DeepFryingRecipe> findMatchingRecipe(Level level) {
        for (RecipeHolder holder : level.getRecipeManager().getAllRecipesFor(RecipeRegistry.DEEP_FRYING.getType())) {
            DeepFryingRecipe deepFryingRecipe;
            Recipe recipe = holder.value();
            if (!(recipe instanceof DeepFryingRecipe) || !this.matchesRecipe(deepFryingRecipe = (DeepFryingRecipe)recipe)) continue;
            return Optional.of(deepFryingRecipe);
        }
        return Optional.empty();
    }

    private boolean matchesRecipe(DeepFryingRecipe recipe) {
        ItemStack inputStack = this.inputInv.getStackInSlot(0);
        if (!((Ingredient)recipe.getIngredients().get(0)).test(inputStack)) {
            return false;
        }
        Optional<BasinBlockEntity> basinOpt = this.getBasin();
        if (basinOpt.isEmpty()) {
            return false;
        }
        BasinBlockEntity basin = basinOpt.get();
        IFluidHandler fluidHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, basin.getBlockPos(), null);
        if (fluidHandler == null) {
            return false;
        }
        for (SizedFluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            int requiredAmount = fluidIngredient.amount();
            int totalMatchingAmount = 0;
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                FluidStack fluidInTank = fluidHandler.getFluidInTank(tank);
                if (fluidIngredient.test(fluidInTank)) {
                    totalMatchingAmount += fluidInTank.getAmount();
                }
                if (totalMatchingAmount >= requiredAmount) break;
            }
            if (totalMatchingAmount >= requiredAmount) continue;
            return false;
        }
        return true;
    }

    private boolean areBasinFluidsMatching(BasinBlockEntity basin, DeepFryingRecipe recipe) {
        IFluidHandler fluidHandler = (IFluidHandler)basin.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, basin.getBlockPos(), null);
        if (fluidHandler == null) {
            return false;
        }
        for (SizedFluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            FluidStack fluidInTank;
            int requiredAmount = fluidIngredient.amount();
            int totalMatchingAmount = 0;
            for (int tank = 0; !(tank >= fluidHandler.getTanks() || fluidIngredient.test(fluidInTank = fluidHandler.getFluidInTank(tank)) && MechanicalFryerEntity.hasMatchingNBT(fluidIngredient, fluidInTank) && (totalMatchingAmount += fluidInTank.getAmount()) >= requiredAmount); ++tank) {
            }
            if (totalMatchingAmount >= requiredAmount) continue;
            return false;
        }
        return true;
    }

    private static boolean hasMatchingNBT(SizedFluidIngredient fluidIngredient, FluidStack fluidInTank) {
        for (FluidStack matchingFluid : fluidIngredient.getFluids()) {
            boolean neitherHaveTag;
            boolean bothHaveTag = !fluidInTank.getComponents().isEmpty() && !matchingFluid.getComponents().isEmpty();
            boolean bl = neitherHaveTag = fluidInTank.getComponents().isEmpty() && matchingFluid.getComponents().isEmpty();
            if (!(bothHaveTag ? fluidInTank.getComponents().equals((Object)matchingFluid.getComponents()) : neitherHaveTag)) continue;
            return true;
        }
        return false;
    }

    public void renderParticles() {
        Optional<BasinBlockEntity> basin = this.getBasin();
        if (basin.isEmpty() || this.level == null) {
            return;
        }
        for (SmartFluidTankBehaviour behaviour : basin.get().getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                this.spillParticle(FluidFX.getFluidParticle((FluidStack)tankSegment.getRenderedFluid()));
            }
        }
    }

    protected void spillParticle(ParticleOptions data) {
        float angle = this.level.random.nextFloat() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.25);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y).add(0.0, 0.25, 0.0);
        Vec3 center = offset.add(VecHelper.getCenterOf((Vec3i)this.worldPosition));
        target = VecHelper.offsetRandomly((Vec3)target.subtract(offset), (RandomSource)this.level.random, (float)0.0078125f);
        this.level.addParticle(data, center.x, center.y - 1.75, center.z, target.x, target.y, target.z);
    }

    @Override
    protected boolean matchStaticFilters(RecipeHolder<? extends Recipe<?>> holder) {
        return holder.value().getType() == RecipeRegistry.DEEP_FRYING.getType();
    }

    @Override
    public void startProcessingBasin() {
        if (this.running && this.runningTicks <= 20) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        this.runningTicks = 0;
    }

    @Override
    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.runningTicks = 40;
        this.running = false;
    }

    @Override
    protected Object getRecipeCacheKey() {
        return DeepFryingRecipesKey;
    }

    @Override
    protected boolean isRunning() {
        return this.running;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        boolean slow;
        super.tickAudio();
        boolean bl = slow = Math.abs(this.getSpeed()) < 65.0f;
        if (slow && AnimationTickHolder.getTicks() % 2 == 0) {
            return;
        }
        if (this.runningTicks == 20) {
            SoundsRegistry.FRYING.playAt(this.level, (Vec3i)this.worldPosition, 0.75f, 1.0f, true);
            this.renderParticles();
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityRegistry.MECHANICAL_FRYER.get(), (blockEntity, context) -> blockEntity.inventoryHandler);
    }

    public boolean canProcess(ItemStack stack) {
        if (this.lastRecipe != null && this.isItemValidForRecipe(this.lastRecipe, stack)) {
            return true;
        }
        List<DeepFryingRecipe> recipes = this.level.getRecipeManager().getAllRecipesFor(RecipeRegistry.DEEP_FRYING.get()).stream().map(RecipeHolder::value).toList();
        for (DeepFryingRecipe recipe : recipes) {
            if (!this.isItemValidForRecipe(recipe, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean isItemValidForRecipe(DeepFryingRecipe recipe, ItemStack stack) {
        return recipe.getIngredients().stream().anyMatch(ingredient -> ingredient.test(stack));
    }

    private class FryerInventoryHandler
    extends CombinedInvWrapper {
        public FryerInventoryHandler(SmartInventory inputInv, SmartInventory outputInv) {
            super(new IItemHandlerModifiable[]{inputInv, outputInv});
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (MechanicalFryerEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return MechanicalFryerEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (MechanicalFryerEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (MechanicalFryerEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

