/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lz;

import java.io.DataInputStream;
import java.io.IOException;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.CorruptedInputException;

public final class LZDecoder {
    private final byte[] buf;
    private final int bufSize;
    private int start = 0;
    private int pos = 0;
    private int full = 0;
    private int limit = 0;
    private int pendingLen = 0;
    private int pendingDist = 0;

    public LZDecoder(int i, byte[] bs, ArrayCache arrayCache) {
        this.bufSize = i;
        this.buf = arrayCache.getByteArray(this.bufSize, false);
        if (bs != null) {
            this.full = this.pos = Math.min(bs.length, i);
            this.start = this.pos;
            System.arraycopy(bs, bs.length - this.pos, this.buf, 0, this.pos);
        }
    }

    public void putArraysToCache(ArrayCache arrayCache) {
        arrayCache.putArray(this.buf);
    }

    public void reset() {
        this.start = 0;
        this.pos = 0;
        this.full = 0;
        this.limit = 0;
        this.buf[this.bufSize - 1] = 0;
    }

    public void setLimit(int i) {
        this.limit = this.bufSize - this.pos <= i ? this.bufSize : this.pos + i;
    }

    public boolean hasSpace() {
        return this.pos < this.limit;
    }

    public boolean hasPending() {
        return this.pendingLen > 0;
    }

    public int getPos() {
        return this.pos;
    }

    public int getByte(int i) {
        int n = this.pos - i - 1;
        if (i >= this.pos) {
            n += this.bufSize;
        }
        return this.buf[n] & 0xFF;
    }

    public void putByte(byte b) {
        this.buf[this.pos++] = b;
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public void repeat(int i, int j) throws IOException {
        int n;
        if (i < 0 || i >= this.full) {
            throw new CorruptedInputException();
        }
        int n2 = Math.min(this.limit - this.pos, j);
        this.pendingLen = j - n2;
        this.pendingDist = i;
        int n3 = this.pos - i - 1;
        if (n3 < 0) {
            assert (this.full == this.bufSize);
            n = Math.min(this.bufSize - (n3 += this.bufSize), n2);
            assert (n <= i + 1);
            System.arraycopy(this.buf, n3, this.buf, this.pos, n);
            this.pos += n;
            n3 = 0;
            if ((n2 -= n) == 0) {
                return;
            }
        }
        assert (n3 < this.pos);
        assert (n2 > 0);
        do {
            n = Math.min(n2, this.pos - n3);
            System.arraycopy(this.buf, n3, this.buf, this.pos, n);
            this.pos += n;
        } while ((n2 -= n) > 0);
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public void repeatPending() throws IOException {
        if (this.pendingLen > 0) {
            this.repeat(this.pendingDist, this.pendingLen);
        }
    }

    public void copyUncompressed(DataInputStream dataInputStream, int i) throws IOException {
        int n = Math.min(this.bufSize - this.pos, i);
        dataInputStream.readFully(this.buf, this.pos, n);
        this.pos += n;
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public int flush(byte[] bs, int i) {
        int n = this.pos - this.start;
        if (this.pos == this.bufSize) {
            this.pos = 0;
        }
        System.arraycopy(this.buf, this.start, bs, i, n);
        this.start = this.pos;
        return n;
    }
}

