/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiLevelType;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiCustomRenderRegister;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.DimensionTypeWrapper;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.apache.logging.log4j.Logger;

public class ServerLevelWrapper
implements IServerLevelWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final Map<class_3218, WeakReference<ServerLevelWrapper>> LEVEL_WRAPPER_REF_BY_SERVER_LEVEL = Collections.synchronizedMap(new WeakHashMap());
    private final class_3218 level;
    @Deprecated
    private IDhLevel parentDhLevel;

    public static ServerLevelWrapper getWrapper(class_3218 level) {
        return (ServerLevelWrapper)LEVEL_WRAPPER_REF_BY_SERVER_LEVEL.compute(level, (newLevel, levelRef) -> {
            ServerLevelWrapper oldLevelWrapper;
            if (levelRef != null && (oldLevelWrapper = (ServerLevelWrapper)levelRef.get()) != null) {
                return levelRef;
            }
            return new WeakReference<ServerLevelWrapper>(new ServerLevelWrapper((class_3218)newLevel));
        }).get();
    }

    public ServerLevelWrapper(class_3218 level) {
        this.level = level;
    }

    @Override
    public File getMcSaveFolder() {
        return this.level.method_14178().method_17981().field_17664;
    }

    @Override
    public String getWorldFolderName() {
        return this.level.method_8503().method_3847((class_5321)class_1937.field_25179).method_14178().method_17981().field_17664.getParentFile().getName();
    }

    @Override
    public DimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.level.method_8597());
    }

    @Override
    public String getDimensionName() {
        return this.level.method_27983().method_29177().toString();
    }

    @Override
    public long getHashedSeed() {
        return this.level.method_22385().field_20641;
    }

    @Override
    public String getDhIdentifier() {
        return this.getDimensionName();
    }

    @Override
    public EDhApiLevelType getLevelType() {
        return EDhApiLevelType.SERVER_LEVEL;
    }

    public class_3218 getLevel() {
        return this.level;
    }

    @Override
    public boolean hasCeiling() {
        return this.level.method_8597().comp_643();
    }

    @Override
    public boolean hasSkyLight() {
        return this.level.method_8597().comp_642();
    }

    @Override
    public int getMaxHeight() {
        return this.level.method_31605();
    }

    @Override
    public int getMinHeight() {
        return this.level.method_31607();
    }

    @Override
    public IChunkWrapper tryGetChunk(DhChunkPos pos) {
        if (!this.level.method_8393(pos.getX(), pos.getZ())) {
            return null;
        }
        class_2791 chunk = this.level.method_8402(pos.getX(), pos.getZ(), class_2806.field_12803, false);
        if (chunk == null) {
            return null;
        }
        return new ChunkWrapper(chunk, this);
    }

    @Override
    public boolean hasChunkLoaded(int chunkX, int chunkZ) {
        class_3215 source = this.level.method_14178();
        return source.method_12123(chunkX, chunkZ);
    }

    @Override
    public IBlockStateWrapper getBlockState(DhBlockPos pos) {
        return BlockStateWrapper.fromBlockState(this.level.method_8320(McObjectConverter.Convert(pos)), this);
    }

    @Override
    public IBiomeWrapper getBiome(DhBlockPos pos) {
        return BiomeWrapper.getBiomeWrapper((class_6880<class_1959>)this.level.method_23753(McObjectConverter.Convert(pos)), this);
    }

    public class_3218 getWrappedMcObject() {
        return this.level;
    }

    @Override
    public void onUnload() {
        LEVEL_WRAPPER_REF_BY_SERVER_LEVEL.remove(this.level);
    }

    @Override
    public void setParentLevel(IDhLevel parentLevel) {
        this.parentDhLevel = parentLevel;
    }

    @Override
    public IDhApiCustomRenderRegister getRenderRegister() {
        if (this.parentDhLevel == null) {
            return null;
        }
        return this.parentDhLevel.getGenericRenderer();
    }

    @Override
    public File getDhSaveFolder() {
        if (this.parentDhLevel == null) {
            return null;
        }
        return this.parentDhLevel.getSaveStructure().getSaveFolder(this);
    }

    public String toString() {
        return "Wrapped{" + this.level.toString() + "@" + this.getDhIdentifier() + "}";
    }
}

