/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.util;

import com.google.common.collect.ForwardingMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TagInjector {
    @ApiStatus.Internal
    public static final HashMap<TagLocation, Set<TagEntry>> ADDITIONS = new HashMap();
    private static final Map<TagLocation, Set<TagEntry>> ADDITIONS_VIEW = new ForwardingMap<TagLocation, Set<TagEntry>>(){

        @NotNull
        protected Map<TagLocation, Set<TagEntry>> delegate() {
            return Collections.unmodifiableMap(ADDITIONS);
        }

        public Set<TagEntry> get(@Nullable Object key) {
            return Collections.unmodifiableSet((Set)this.delegate().get(key));
        }
    };

    private TagInjector() {
    }

    public static Map<TagLocation, Set<TagEntry>> getInjections() {
        return ADDITIONS_VIEW;
    }

    public static void injectRaw(Registry<?> registry, ResourceLocation tag, Function<ResourceLocation, TagEntry> entryMaker, Collection<ResourceLocation> values) {
        ADDITIONS.computeIfAbsent(new TagLocation(Registries.tagsDirPath((ResourceKey)registry.key()), tag), identifier -> new HashSet()).addAll(values.stream().map(entryMaker).toList());
    }

    public static void injectRaw(Registry<?> registry, ResourceLocation tag, Function<ResourceLocation, TagEntry> entryMaker, ResourceLocation ... values) {
        TagInjector.injectRaw(registry, tag, entryMaker, Arrays.asList(values));
    }

    public static <T> void inject(Registry<T> registry, ResourceLocation tag, Collection<T> values) {
        TagInjector.injectDirectReference(registry, tag, values.stream().map(arg_0 -> registry.getKey(arg_0)).toList());
    }

    @SafeVarargs
    public static <T> void inject(Registry<T> registry, ResourceLocation tag, T ... values) {
        TagInjector.inject(registry, tag, Arrays.asList(values));
    }

    public static void injectDirectReference(Registry<?> registry, ResourceLocation tag, Collection<ResourceLocation> values) {
        TagInjector.injectRaw(registry, tag, TagEntry::element, values);
    }

    public static void injectDirectReference(Registry<?> registry, ResourceLocation tag, ResourceLocation ... values) {
        TagInjector.injectDirectReference(registry, tag, Arrays.asList(values));
    }

    public static void injectTagReference(Registry<?> registry, ResourceLocation tag, Collection<ResourceLocation> values) {
        TagInjector.injectRaw(registry, tag, TagEntry::tag, values);
    }

    public static void injectTagReference(Registry<?> registry, ResourceLocation tag, ResourceLocation ... values) {
        TagInjector.injectTagReference(registry, tag, Arrays.asList(values));
    }

    public record TagLocation(String type, ResourceLocation tagId) {
    }
}

