/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.network.client;

import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.common.capability.IPlayerRecipeData;
import com.illusivesoulworks.polymorph.common.integration.PolymorphIntegrations;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;

public record CPacketPlayerRecipeSelection(ResourceLocation recipe) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CPacketPlayerRecipeSelection> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"polymorph", (String)"player_recipe_selection"));
    public static final StreamCodec<FriendlyByteBuf, CPacketPlayerRecipeSelection> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, CPacketPlayerRecipeSelection::recipe, CPacketPlayerRecipeSelection::new);

    public static void handle(CPacketPlayerRecipeSelection packet, ServerPlayer player) {
        AbstractContainerMenu container = player.containerMenu;
        player.level().getRecipeManager().byKey(packet.recipe).ifPresent(recipe -> {
            PolymorphApi api = PolymorphApi.getInstance();
            IPlayerRecipeData recipeData = api.getPlayerRecipeData((Player)player);
            if (recipeData != null) {
                recipeData.selectRecipe((RecipeHolder<?>)recipe);
            }
            PolymorphIntegrations.selectRecipe(container, recipe);
            container.slotsChanged((Container)player.getInventory());
            if (container instanceof ItemCombinerMenu) {
                ((ItemCombinerMenu)container).createResult();
                container.broadcastChanges();
                api.getNetwork().sendUpdatePreviewS2C(player);
            }
        });
    }

    @Nonnull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

