/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.YungsApiNeoForge;
import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterBlockEntityType;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegistrationManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlockEntityTypeModuleNeoForge {
    private static final Map<String, DeferredRegister<BlockEntityType<?>>> registersByModId = new HashMap();

    public static void processEntries() {
        AutoRegistrationManager.BLOCK_ENTITY_TYPES.stream().filter(data -> !data.processed()).forEach(BlockEntityTypeModuleNeoForge::register);
    }

    private static void register(AutoRegisterField data) {
        String modId = data.name().getNamespace();
        if (!registersByModId.containsKey(modId)) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)modId);
            deferredRegister.register(YungsApiNeoForge.loadingContextEventBus);
            registersByModId.put(modId, deferredRegister);
        }
        AutoRegisterBlockEntityType autoRegisterBlockEntityType = (AutoRegisterBlockEntityType)data.object();
        Supplier blockEntityTypeSupplier = autoRegisterBlockEntityType.getSupplier();
        DeferredRegister<BlockEntityType<?>> deferredRegister = registersByModId.get(modId);
        DeferredHolder registryObject = deferredRegister.register(data.name().getPath(), blockEntityTypeSupplier);
        autoRegisterBlockEntityType.setSupplier(registryObject);
        data.markProcessed();
    }
}

