/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight.datagen;

import com.sammy.minersdelight.MinersDelightMod;
import com.sammy.minersdelight.datagen.MdRecipeReplacements;
import com.sammy.minersdelight.setup.MDBlocks;
import com.sammy.minersdelight.setup.MDItems;
import com.sammy.minersdelight.setup.MDTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public class MDRecipeProvider
extends RecipeProvider {
    private final MdRecipeReplacements vanillaRecipeReplacements;

    public MDRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
        this.vanillaRecipeReplacements = new MdRecipeReplacements(output, registries);
    }

    public String getName() {
        return "Miner's Delight Recipe Provider";
    }

    private static Ingredient vegetablesPatch() {
        return DifferenceIngredient.of((Ingredient)Ingredient.of((TagKey)Tags.Items.FOODS_VEGETABLE), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.MELON_SLICE}));
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.vanillaRecipeReplacements.buildRecipes(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)MDBlocks.COPPER_POT.get())).define(Character.valueOf('X'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('Y'), (ItemLike)Items.WOODEN_SHOVEL).define(Character.valueOf('Z'), Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET, (ItemLike)MDItems.WATER_CUP.get()})).pattern(" Y ").pattern("XZX").pattern("XXX").unlockedBy("has_copper", MDRecipeProvider.has((TagKey)Tags.Items.INGOTS_COPPER)).save(recipeOutput, MinersDelightMod.path("copper_pot"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)MDBlocks.STICKY_BASKET.get())).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('Y'), (ItemLike)Items.COBWEB).pattern("X X").pattern("Y Y").pattern("XYX").unlockedBy("has_cobweb", MDRecipeProvider.has((ItemLike)Items.COBWEB)).save(recipeOutput, MinersDelightMod.path("sticky_basket"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)MDItems.COPPER_CUP.get())).define(Character.valueOf('X'), Tags.Items.INGOTS_COPPER).pattern("X X").pattern(" X ").unlockedBy("has_copper", MDRecipeProvider.has((TagKey)Tags.Items.INGOTS_COPPER)).save(recipeOutput, MinersDelightMod.path("copper_cup"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MDBlocks.CAVE_CARROT_CRATE.get())).define(Character.valueOf('X'), (ItemLike)MDItems.CAVE_CARROT.get()).pattern("XXX").pattern("XXX").pattern("XXX").unlockedBy("has_cave_carrot", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.CAVE_CARROT.get()))).save(recipeOutput, MinersDelightMod.path("cave_carrot_crate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.COPPER_CARROT.get())).define(Character.valueOf('X'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('Y'), (ItemLike)MDItems.CAVE_CARROT.get()).pattern("XXX").pattern("XYX").pattern("XXX").unlockedBy("has_copper", MDRecipeProvider.has((TagKey)Tags.Items.INGOTS_COPPER)).save(recipeOutput, MinersDelightMod.path("copper_carrot"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.IMPROVISED_BARBECUE_STICK.get()), (int)1).requires(MDTags.BAKED_CAVE_CARROT).requires((ItemLike)Items.BROWN_MUSHROOM).requires((ItemLike)MDItems.SMOKED_BAT_WING.get()).requires(Tags.Items.RODS_WOODEN).unlockedBy("has_cave_carrot", MDRecipeProvider.has((ItemLike)((ItemLike)MDBlocks.CAVE_CARROTS.get()))).save(recipeOutput, MinersDelightMod.path("improvised_barbecue_stick"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.VEGAN_STEAK_AND_POTATOES.get()), (int)1).requires((ItemLike)Items.BAKED_POTATO).requires(MDTags.BAKED_CAVE_CARROT).requires(CommonTags.FOODS_ONION).requires((ItemLike)ModItems.COOKED_RICE.get()).requires((ItemLike)Items.BOWL).unlockedBy("has_cave_carrot", MDRecipeProvider.has((ItemLike)((ItemLike)MDBlocks.CAVE_CARROTS.get()))).save(recipeOutput, MinersDelightMod.path("vegan_steak_and_potatoes"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.VEGAN_HAMBURGER.get()), (int)1).requires(Tags.Items.FOODS_BREAD).requires((ItemLike)MDItems.VEGAN_PATTY.get()).requires(CommonTags.CROPS_CABBAGE).requires(CommonTags.FOODS_TOMATO).requires(CommonTags.FOODS_ONION).unlockedBy("has_cave_carrot", MDRecipeProvider.has((ItemLike)((ItemLike)MDBlocks.CAVE_CARROTS.get()))).save(recipeOutput, MinersDelightMod.path("vegan_hamburger"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.CAVE_HAMBURGER.get()), (int)1).requires(Tags.Items.FOODS_BREAD).requires((ItemLike)MDItems.VEGAN_PATTY.get()).requires((ItemLike)MDItems.SMOKED_BAT_WING.get()).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.BAKED_TENTACLES.get(), Items.BROWN_MUSHROOM}), 2).unlockedBy("has_cave_carrot", MDRecipeProvider.has((ItemLike)((ItemLike)MDBlocks.CAVE_CARROTS.get()))).save(recipeOutput, MinersDelightMod.path("cave_hamburger"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.VEGAN_WRAP.get()), (int)1).requires(Tags.Items.FOODS_BREAD).requires(CommonTags.FOODS_ONION).requires(MDTags.BAKED_CAVE_CARROT).unlockedBy("has_cave_carrot", MDRecipeProvider.has((ItemLike)((ItemLike)MDBlocks.CAVE_CARROTS.get()))).save(recipeOutput, MinersDelightMod.path("vegan_wrap"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.BAT_COOKIE.get()), (int)8).requires((ItemLike)MDItems.SMOKED_BAT_WING.get(), 1).requires(Tags.Items.CROPS_WHEAT).requires(Tags.Items.CROPS_WHEAT).unlockedBy("has_bat_wing", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.BAT_WING.get()))).save(recipeOutput, MinersDelightMod.path("bat_cookie"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.TENTACLES_ON_A_STICK.get()), (int)1).requires(Tags.Items.RODS_WOODEN).requires((ItemLike)MDItems.BAKED_TENTACLES.get(), 2).unlockedBy("has_squid", MDRecipeProvider.has(MDTags.SQUID)).save(recipeOutput, MinersDelightMod.path("tentacles_on_a_stick"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.SQUID_SANDWICH.get()), (int)1).requires(MDTags.COOKED_FISHES_SQUID).requires(Tags.Items.FOODS_BREAD).unlockedBy("has_squid", MDRecipeProvider.has(MDTags.SQUID)).save(recipeOutput, MinersDelightMod.path("squid_sandwich"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.WEIRD_CAVIAR.get()), (int)1).requires((ItemLike)Items.BOWL).requires((ItemLike)MDItems.SILVERFISH_EGGS.get(), 3).unlockedBy("has_silverfish_eggs", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.SILVERFISH_EGGS.get()))).save(recipeOutput, MinersDelightMod.path("weird_caviar"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.SEASONED_ARTHROPODS.get()), (int)1).requires((ItemLike)Items.BOWL).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.COOKED_ARTHROPOD.get(), (ItemLike)MDItems.CRUNCHY_BAR.get()})).requires((ItemLike)MDItems.WEIRD_CAVIAR.get()).unlockedBy("has_arthropod", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.ARTHROPOD.get()))).save(recipeOutput, MinersDelightMod.path("seasoned_arthropods"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.INSECT_SANDWICH.get()), (int)2).requires(Tags.Items.FOODS_BREAD).requires(MDTags.COOKED_INSECT_MEAT).requires(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(MDTags.COOKED_INSECT_MEAT), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.WEIRD_CAVIAR.get()})})).requires(Tags.Items.FOODS_BREAD).unlockedBy("has_arthropod", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.ARTHROPOD.get()))).save(recipeOutput, MinersDelightMod.path("insect_sandwich"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.INSECT_WRAP.get()), (int)1).requires(Tags.Items.FOODS_BREAD).requires(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_ONION), Ingredient.of(MDTags.INSECT_MEAT)})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.ARTHROPOD.get(), (ItemLike)MDItems.SILVERFISH_EGGS.get()}), 2).unlockedBy("has_arthropod", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.ARTHROPOD.get()))).save(recipeOutput, MinersDelightMod.path("insect_wrap"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.INSECT_WRAP.get()), (int)1).requires(Tags.Items.FOODS_BREAD).requires(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_ONION), Ingredient.of(MDTags.INSECT_MEAT)})).requires((ItemLike)MDItems.CRUNCHY_BAR.get()).unlockedBy("has_arthropod", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.ARTHROPOD.get()))).save(recipeOutput, MinersDelightMod.path("alt_insect_wrap"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.CRUNCHY_BAR.get()), (int)4).requires((ItemLike)MDItems.COOKED_ARTHROPOD.get(), 3).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.COOKED_ARTHROPOD.get(), (ItemLike)MDItems.SILVERFISH_EGGS.get()})).requires((ItemLike)MDItems.SILVERFISH_EGGS.get(), 3).unlockedBy("has_arthropod", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.ARTHROPOD.get()))).save(recipeOutput, MinersDelightMod.path("crunchy_bar"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.NUTRITIONAL_BAR.get()), (int)4).requires((ItemLike)MDItems.CRUNCHY_BAR.get(), 4).requires((ItemLike)Items.WHEAT, 2).requires((ItemLike)Items.HONEY_BOTTLE).unlockedBy("has_crunchy_bar", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.CRUNCHY_BAR.get()))).save(recipeOutput, MinersDelightMod.path("nutritional_bar"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.GOLDEN_NUTRITIONAL_BAR.get()), (int)1).define(Character.valueOf('X'), Tags.Items.NUGGETS_GOLD).define(Character.valueOf('Y'), (ItemLike)MDItems.NUTRITIONAL_BAR.get()).pattern("XXX").pattern("XYX").pattern("XXX").unlockedBy("has_nutritional_bar", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.NUTRITIONAL_BAR.get()))).save(recipeOutput, MinersDelightMod.path("golden_nutritional_bar"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.GLAZED_ARACHNID_LIMBS.get()), (int)1).requires((ItemLike)MDItems.BAKED_SPIDER_LEG.get()).requires((ItemLike)Items.HONEY_BOTTLE).requires((ItemLike)MDItems.BAKED_SPIDER_LEG.get()).requires((ItemLike)MDItems.BAKED_SPIDER_LEG.get()).requires((ItemLike)ModItems.COOKED_RICE.get()).requires((ItemLike)MDItems.BAKED_SPIDER_LEG.get()).requires((ItemLike)Items.GLOW_BERRIES).requires((ItemLike)Items.BOWL).requires((ItemLike)Items.GLOW_BERRIES).unlockedBy("has_spider_leg", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.SPIDER_LEG.get()))).save(recipeOutput, MinersDelightMod.path("glazed_arachnid_limbs"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.CAVE_CARROT.get()), (int)9).requires((ItemLike)MDBlocks.CAVE_CARROT_CRATE.get()).unlockedBy("has_cave_carrot", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.CAVE_CARROT.get()))).save(recipeOutput, MinersDelightMod.path("cave_carrots_from_crate"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STRING, (int)2).requires((ItemLike)MDBlocks.GOSSYPIUM.get()).unlockedBy("has_gossypium", MDRecipeProvider.has((ItemLike)((ItemLike)MDBlocks.GOSSYPIUM.get()))).save(recipeOutput, MinersDelightMod.path("string_from_gossypium"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.CAVE_CARROT.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.BAKED_CAVE_CARROT.get()), (float)0.25f, (int)200).unlockedBy("has_cave_carrot", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.CAVE_CARROT.get()))).save(recipeOutput, MinersDelightMod.path("baked_cave_carrot"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.CAVE_CARROT.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.BAKED_CAVE_CARROT.get()), (float)0.25f, (int)100).unlockedBy("has_cave_carrot", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.CAVE_CARROT.get()))).save(recipeOutput, MinersDelightMod.path("baked_cave_carrot_smoking"));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.CAVE_CARROT.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.BAKED_CAVE_CARROT.get()), (float)0.25f, (int)600).unlockedBy("has_cave_carrot", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.CAVE_CARROT.get()))).save(recipeOutput, MinersDelightMod.path("baked_cave_carrot_campfire"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.BAT_WING.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.SMOKED_BAT_WING.get()), (float)0.25f, (int)200).unlockedBy("has_bat_wing", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.BAT_WING.get()))).save(recipeOutput, MinersDelightMod.path("smoked_bat_wing"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.BAT_WING.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.SMOKED_BAT_WING.get()), (float)0.25f, (int)100).unlockedBy("has_bat_wing", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.BAT_WING.get()))).save(recipeOutput, MinersDelightMod.path("smoked_bat_wing_smoking"));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.BAT_WING.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.SMOKED_BAT_WING.get()), (float)0.25f, (int)600).unlockedBy("has_bat_wing", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.BAT_WING.get()))).save(recipeOutput, MinersDelightMod.path("smoked_bat_wing_campfire"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.TENTACLES.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.BAKED_TENTACLES.get()), (float)0.25f, (int)200).unlockedBy("has_tentacles", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.TENTACLES.get()))).save(recipeOutput, MinersDelightMod.path("baked_tentacles"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.TENTACLES.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.BAKED_TENTACLES.get()), (float)0.25f, (int)100).unlockedBy("has_tentacles", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.TENTACLES.get()))).save(recipeOutput, MinersDelightMod.path("baked_tentacles_smoking"));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.TENTACLES.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.BAKED_TENTACLES.get()), (float)0.25f, (int)600).unlockedBy("has_tentacles", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.TENTACLES.get()))).save(recipeOutput, MinersDelightMod.path("baked_tentacles_campfire"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.SQUID.get(), (ItemLike)MDItems.GLOW_SQUID.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.BAKED_SQUID.get()), (float)0.25f, (int)200).unlockedBy("has_squid", MDRecipeProvider.has(MDTags.SQUID)).save(recipeOutput, MinersDelightMod.path("baked_squid"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.SQUID.get(), (ItemLike)MDItems.GLOW_SQUID.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.BAKED_SQUID.get()), (float)0.25f, (int)100).unlockedBy("has_squid", MDRecipeProvider.has(MDTags.SQUID)).save(recipeOutput, MinersDelightMod.path("baked_squid_smoking"));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.SQUID.get(), (ItemLike)MDItems.GLOW_SQUID.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.BAKED_SQUID.get()), (float)0.25f, (int)600).unlockedBy("has_squid", MDRecipeProvider.has(MDTags.SQUID)).save(recipeOutput, MinersDelightMod.path("baked_squid_campfire"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.ARTHROPOD.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.COOKED_ARTHROPOD.get()), (float)0.25f, (int)200).unlockedBy("has_arthropod", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.ARTHROPOD.get()))).save(recipeOutput, MinersDelightMod.path("cooked_arthropod"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.SPIDER_LEG.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.BAKED_SPIDER_LEG.get()), (float)0.25f, (int)300).unlockedBy("has_spider_leg", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.SPIDER_LEG.get()))).save(recipeOutput, MinersDelightMod.path("baked_spider_leg"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.SPIDER_LEG.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.BAKED_SPIDER_LEG.get()), (float)0.25f, (int)150).unlockedBy("has_spider_leg", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.SPIDER_LEG.get()))).save(recipeOutput, MinersDelightMod.path("baked_spider_leg_smoking"));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.SPIDER_LEG.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MDItems.BAKED_SPIDER_LEG.get()), (float)0.25f, (int)600).unlockedBy("has_spider_leg", MDRecipeProvider.has((ItemLike)((ItemLike)MDItems.SPIDER_LEG.get()))).save(recipeOutput, MinersDelightMod.path("baked_spider_leg_campfire"));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)MDItems.PASTA_WITH_VEGGIEBALLS.get()), (int)1, (int)400, (float)2.0f).addIngredient(MDTags.BAKED_CAVE_CARROT).addIngredient(CommonTags.FOODS_PASTA).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)MDItems.CAVE_CARROT.get(), (ItemLike)ModItems.RAW_PASTA.get(), (ItemLike)ModItems.TOMATO_SAUCE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(recipeOutput, "minersdelight:cooking/pasta_with_veggieballs");
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)MDItems.FAKE_MEATLOAF.get()), (int)1, (int)400, (float)2.0f, (ItemLike)Items.BOWL).addIngredient(Ingredient.of(MDTags.BAKED_CAVE_CARROT), 2).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.BAKED_CAVE_CARROT.get(), Items.CARROT})).addIngredient(CommonTags.FOODS_ONION).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)MDItems.CAVE_CARROT.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(recipeOutput, "minersdelight:cooking/fake_meatloaf");
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)MDItems.CAVE_SOUP.get()), (int)1, (int)200, (float)1.0f).addIngredient(MDTags.CAVE_CARROTS_VEGETABLE_ITEM).addIngredient((ItemLike)Items.RED_MUSHROOM).addIngredient((ItemLike)Items.BROWN_MUSHROOM, 2).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)MDItems.CAVE_CARROT.get(), Items.RED_MUSHROOM, Items.BROWN_MUSHROOM}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(recipeOutput, "minersdelight:cooking/cave_soup");
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)MDItems.INSECT_STEW.get()), (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)MDItems.ARTHROPOD.get()).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.ARTHROPOD.get(), (ItemLike)MDItems.SILVERFISH_EGGS.get()}), 3).unlockedByItems("has_arthropod", new ItemLike[]{(ItemLike)MDItems.ARTHROPOD.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(recipeOutput, "minersdelight:cooking/insect_stew");
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)MDItems.INSECT_STEW.get()), (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)MDItems.CRUNCHY_BAR.get()).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.ARTHROPOD.get(), (ItemLike)MDItems.CRUNCHY_BAR.get()})).unlockedByItems("has_arthropod", new ItemLike[]{(ItemLike)MDItems.ARTHROPOD.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(recipeOutput, "minersdelight:cooking/alt_insect_stew");
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)MDItems.BAT_SOUP.get()), (int)1, (int)200, (float)1.0f).addIngredient(MDTags.BAT_WING).addIngredient(MDTags.BAT_WING).unlockedByItems("has_bat_wing", new ItemLike[]{(ItemLike)MDItems.BAT_WING.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(recipeOutput, "minersdelight:cooking/bat_soup");
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)MDItems.BAT_ROLLS.get()), (int)1, (int)200, (float)1.0f).addIngredient(MDTags.BAT_WING).addIngredient(ModTags.CABBAGE_ROLL_INGREDIENTS).unlockedByItems("has_bat_wing", new ItemLike[]{(ItemLike)MDItems.BAT_WING.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(recipeOutput, "minersdelight:cooking/bat_rolls");
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)MDItems.TAKOYAKI.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.BOWL).addIngredient(MDTags.TENTACLES).addIngredient(MDTags.TENTACLES).addIngredient(CommonTags.FOODS_DOUGH).addIngredient(CommonTags.FOODS_ONION).unlockedBy("has_squid", MDRecipeProvider.has(MDTags.SQUID)).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(recipeOutput, "minersdelight:cooking/takoyaki");
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)MDBlocks.STUFFED_SQUID.get()), (int)1, (int)400, (float)2.0f, (ItemLike)Items.BOWL).addIngredient(Ingredient.of(MDTags.SQUID)).addIngredient((ItemLike)ModItems.RICE.get(), 2).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.CAVE_CARROT.get(), Items.CARROT})).addIngredient(Tags.Items.EGGS).addIngredient(CommonTags.FOODS_ONION).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)MDItems.SQUID.get(), (ItemLike)MDItems.GLOW_SQUID.get(), (ItemLike)MDItems.BAKED_SQUID.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(recipeOutput, "minersdelight:cooking/stuffed_squid");
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)MDItems.GLOW_INK_PASTA.get()), (int)1, (int)400, (float)2.0f, (ItemLike)Items.BOWL).addIngredient(CommonTags.FOODS_SAFE_RAW_FISH).addIngredient(CommonTags.FOODS_PASTA).addIngredient((ItemLike)Items.GLOW_BERRIES).addIngredient((ItemLike)Items.GLOW_INK_SAC).unlockedBy("has_glow_ink_sac", MDRecipeProvider.has((ItemLike)Items.GLOW_INK_SAC)).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(recipeOutput, "minersdelight:cooking/glow_ink_pasta");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.MOSS_BLOCK}), (Ingredient)Ingredient.of((TagKey)Tags.Items.TOOLS_SHEAR), (ItemLike)((ItemLike)MDItems.MOSS.get()), (int)4).build(recipeOutput, MinersDelightMod.path("cutting/moss"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.BAKED_CAVE_CARROT.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)MDItems.VEGAN_PATTY.get()), (int)2).build(recipeOutput, MinersDelightMod.path("cutting/vegan_patty"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.BAT_WING.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)Items.PHANTOM_MEMBRANE, (int)1).addResultWithChance((ItemLike)Items.PHANTOM_MEMBRANE, 0.5f, 2).build(recipeOutput, MinersDelightMod.path("cutting/bat_wing"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.SQUID.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)MDItems.TENTACLES.get()), (int)3).addResultWithChance((ItemLike)MDItems.TENTACLES.get(), 0.5f).addResult((ItemLike)Items.INK_SAC).addResultWithChance((ItemLike)Items.INK_SAC, 0.5f, 2).build(recipeOutput, MinersDelightMod.path("cutting/squid"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.GLOW_SQUID.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)MDItems.TENTACLES.get()), (int)3).addResultWithChance((ItemLike)MDItems.TENTACLES.get(), 0.5f).addResult((ItemLike)Items.GLOW_INK_SAC).addResultWithChance((ItemLike)Items.GLOW_INK_SAC, 0.5f, 2).build(recipeOutput, MinersDelightMod.path("cutting/glow_squid"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.BAKED_SQUID.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)MDItems.BAKED_TENTACLES.get()), (int)3).addResultWithChance((ItemLike)MDItems.BAKED_TENTACLES.get(), 0.5f).build(recipeOutput, MinersDelightMod.path("cutting/baked_squid"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDBlocks.WILD_CAVE_CARROTS.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.TOOLS_SHEAR), (ItemLike)((ItemLike)MDBlocks.GOSSYPIUM.get()), (int)1).addResultWithChance((ItemLike)MDBlocks.GOSSYPIUM.get(), 0.5f, 1).addResult((ItemLike)MDItems.CAVE_CARROT.get()).addResultWithChance((ItemLike)MDItems.CAVE_CARROT.get(), 0.5f, 2).build(recipeOutput, MinersDelightMod.path("cutting/wild_cave_carrot"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.SPIDER_LEG.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)MDItems.ARTHROPOD.get()), (int)2).addResult((ItemLike)Items.BONE_MEAL).build(recipeOutput, MinersDelightMod.path("cutting/baked_spider_leg"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MDItems.BAKED_SPIDER_LEG.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)MDItems.COOKED_ARTHROPOD.get()), (int)2).addResult((ItemLike)Items.BONE_MEAL).build(recipeOutput, MinersDelightMod.path("cutting/spider_leg"));
    }
}

