/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight.content.block;

import com.sammy.minersdelight.content.block.WildCaveCarrotBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class GossypiumFlowerBlock
extends FlowerBlock {
    public GossypiumFlowerBlock(BlockBehaviour.Properties properties) {
        super(MobEffects.DIG_SPEED, 10.0f, properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WildCaveCarrotBlock.STONE, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(BlockTags.BASE_STONE_OVERWORLD) || state.is(BlockTags.DIRT) || state.is(BlockTags.SAND);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WildCaveCarrotBlock.STONE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.getStateForPlacement(pContext);
        return stateForPlacement != null ? WildCaveCarrotBlock.modifyState((LevelAccessor)pContext.getLevel(), stateForPlacement, pContext.getClickedPos()) : null;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState state = super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        if (state.is(Blocks.AIR)) {
            return state;
        }
        if (pFacing == Direction.DOWN && pFacingState.is(BlockTags.BASE_STONE_OVERWORLD)) {
            state.setValue((Property)WildCaveCarrotBlock.STONE, (Comparable)Boolean.valueOf(true));
        } else {
            state.setValue((Property)WildCaveCarrotBlock.STONE, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }
}

