/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.monster;

import fuzs.eternalnether.EternalNether;
import fuzs.eternalnether.init.ModEntityTypes;
import fuzs.eternalnether.init.ModItems;
import fuzs.eternalnether.world.entity.monster.Wex;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.scores.PlayerTeam;

public class Wraither
extends WitherSkeleton {
    private static final EntityDataAccessor<Boolean> DATA_IS_POSSESSED = SynchedEntityData.defineId(Wraither.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final ResourceLocation SPEED_MODIFIER_DISPOSSESSED_ID = EternalNether.id("dispossessed");
    private static final AttributeModifier SPEED_MODIFIER_DISPOSSESSED = new AttributeModifier(SPEED_MODIFIER_DISPOSSESSED_ID, 0.1, AttributeModifier.Operation.ADD_VALUE);
    private static final float DISPOSSESS_HEALTH_PERCENT = 0.35f;

    public Wraither(EntityType<? extends WitherSkeleton> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.MAX_HEALTH, 24.0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Possessed", this.isPossessed());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setPossessed(tag.getBoolean("Possessed"));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_POSSESSED, (Object)true);
    }

    public void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(ModItems.CUTLASS));
    }

    public boolean isPossessed() {
        return (Boolean)this.entityData.get(DATA_IS_POSSESSED);
    }

    private void setPossessed(boolean possessed) {
        this.entityData.set(DATA_IS_POSSESSED, (Object)possessed);
    }

    public boolean hurt(DamageSource damageSource, float damageAmount) {
        if (super.hurt(damageSource, damageAmount)) {
            if (this.isPossessed() && this.getHealth() / this.getMaxHealth() < 0.35f) {
                this.dispossess();
            }
            return true;
        }
        return false;
    }

    private void dispossess() {
        this.setPossessed(false);
        this.getAttribute(Attributes.MOVEMENT_SPEED).addOrReplacePermanentModifier(SPEED_MODIFIER_DISPOSSESSED);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Wex wex = (Wex)((EntityType)ModEntityTypes.WEX.value()).create((Level)serverLevel);
            if (wex != null) {
                BlockPos blockPos = this.blockPosition().above();
                wex.moveTo(blockPos, this.yBodyRot, this.xRotO);
                wex.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
                wex.setOwner((Mob)this);
                wex.setBoundOrigin(blockPos);
                wex.setLimitedLife(20 * (30 + this.random.nextInt(90)));
                PlayerTeam playerTeam = this.getTeam();
                if (playerTeam != null) {
                    serverLevel.getScoreboard().addPlayerToTeam(wex.getScoreboardName(), playerTeam);
                }
                serverLevel.addFreshEntity((Entity)wex);
            }
        }
    }
}

