/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.data;

import com.google.common.collect.ImmutableMap;
import fuzs.eternalnether.init.ModBlockFamilies;
import fuzs.eternalnether.init.ModBlocks;
import fuzs.eternalnether.init.ModItems;
import fuzs.puzzleslib.api.data.v2.AbstractRecipeProvider;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ModRecipeProvider
extends AbstractRecipeProvider {
    private static final Map<BlockFamily.Variant, BiFunction<ItemLike, ItemLike, RecipeBuilder>> STONECUTTING_BUILDERS = ImmutableMap.builder().put((Object)BlockFamily.Variant.CHISELED, (itemLike, itemLike2) -> SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemLike2}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)itemLike)).put((Object)BlockFamily.Variant.CUT, (itemLike, itemLike2) -> SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemLike2}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)itemLike)).put((Object)BlockFamily.Variant.SLAB, (itemLike, itemLike2) -> SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemLike2}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)itemLike, (int)2)).put((Object)BlockFamily.Variant.STAIRS, (itemLike, itemLike2) -> SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemLike2}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)itemLike)).put((Object)BlockFamily.Variant.POLISHED, (itemLike, itemLike2) -> SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemLike2}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)itemLike)).put((Object)BlockFamily.Variant.WALL, (itemLike, itemLike2) -> SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemLike2}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)itemLike)).build();

    public ModRecipeProvider(DataProviderContext context) {
        super(context);
    }

    public void addRecipes(RecipeOutput recipeOutput) {
        ModRecipeProvider.generateForEnabledBlockFamilies(recipeOutput, FeatureFlags.DEFAULT_FLAGS);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.WARPED_NETHER_BRICKS.value())).define(Character.valueOf('W'), (ItemLike)Items.WARPED_ROOTS).define(Character.valueOf('N'), (ItemLike)Items.NETHER_BRICK).pattern("NW").pattern("WN").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.WARPED_ROOTS), ModRecipeProvider.has((ItemLike)Items.WARPED_ROOTS)).save(recipeOutput);
        ModRecipeProvider.smeltingResultFromBase((RecipeOutput)recipeOutput, (ItemLike)Blocks.BLACKSTONE, (ItemLike)((ItemLike)ModBlocks.COBBLED_BLACKSTONE.value()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.WITHERED_BONE_MEAL.value()), (int)3).requires((ItemLike)ModItems.WITHERED_BONE.value()).group(ModRecipeProvider.getItemName((ItemLike)((ItemLike)ModItems.WITHERED_BONE_MEAL.value()))).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.WITHERED_BONE.value())), ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.WITHERED_BONE.value()))).save(recipeOutput);
        ModRecipeProvider.nineBlockStorageRecipesRecipesWithCustomUnpacking((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.WITHERED_BONE_MEAL.value()), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.WITHERED_BONE_BLOCK.value()), (String)ModRecipeProvider.getConversionRecipeName((ItemLike)((ItemLike)ModItems.WITHERED_BONE_MEAL.value()), (ItemLike)((ItemLike)ModItems.WITHERED_BONE_BLOCK.value())), (String)ModRecipeProvider.getItemName((ItemLike)((ItemLike)ModItems.WITHERED_BONE_MEAL.value())));
    }

    public static void generateForEnabledBlockFamilies(RecipeOutput recipeOutput, FeatureFlagSet enabledFeatures) {
        ModBlockFamilies.getAllFamilies().filter(BlockFamily::shouldGenerateRecipe).forEach(blockFamily -> ModRecipeProvider.generateRecipes(recipeOutput, blockFamily, enabledFeatures));
    }

    public static void generateRecipes(RecipeOutput recipeOutput, BlockFamily blockFamily, FeatureFlagSet requiredFeatures) {
        RecipeProvider.generateRecipes((RecipeOutput)recipeOutput, (BlockFamily)blockFamily, (FeatureFlagSet)requiredFeatures);
        blockFamily.getVariants().forEach((variant, block) -> {
            if (block.requiredFeatures().isSubsetOf(requiredFeatures)) {
                BiFunction<ItemLike, ItemLike, RecipeBuilder> biFunction = STONECUTTING_BUILDERS.get(variant);
                Block itemLike = ModRecipeProvider.getBaseBlock((BlockFamily)blockFamily, (BlockFamily.Variant)variant);
                if (biFunction != null) {
                    RecipeBuilder recipeBuilder = biFunction.apply((ItemLike)block, (ItemLike)itemLike);
                    recipeBuilder.unlockedBy(blockFamily.getRecipeUnlockedBy().orElseGet(() -> ModRecipeProvider.lambda$generateRecipes$7((ItemLike)itemLike)), ModRecipeProvider.has((ItemLike)itemLike));
                    recipeBuilder.save(recipeOutput, ModRecipeProvider.getStonecuttingRecipeName((ItemLike)block, (ItemLike)itemLike));
                }
            }
        });
    }

    @Deprecated(forRemoval=true)
    public static String getStonecuttingRecipeName(ItemLike result, ItemLike material) {
        return ModRecipeProvider.getConversionRecipeName((ItemLike)result, (ItemLike)material) + "_stonecutting";
    }

    private static /* synthetic */ String lambda$generateRecipes$7(ItemLike itemLike) {
        return ModRecipeProvider.getHasName((ItemLike)itemLike);
    }
}

