/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.eternalnether.world.entity.monster.WitherSkeletonKnight;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class WitherSkeletonKnightModel
extends HumanoidModel<WitherSkeletonKnight> {
    public WitherSkeletonKnightModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.getChild("body").addOrReplaceChild("bodywear", CubeListBuilder.create().texOffs(16, 32).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        leftArm.addOrReplaceChild("left_armwear", CubeListBuilder.create().texOffs(40, 32).mirror().addBox(3.0f, -4.0f, -1.5f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.4f)).mirror(false), PartPose.offset((float)-3.0f, (float)2.0f, (float)0.0f));
        rightArm.addOrReplaceChild("right_armwear", CubeListBuilder.create().texOffs(40, 32).addBox(-9.0f, -4.0f, -1.5f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.4f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        leftLeg.addOrReplaceChild("left_legwear", CubeListBuilder.create().texOffs(0, 32).mirror().addBox(0.0f, -12.0f, -2.1f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.1f)).mirror(false), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.1f));
        rightLeg.addOrReplaceChild("right_legwear", CubeListBuilder.create().texOffs(0, 32).addBox(-4.0f, -12.0f, -2.1f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)2.0f, (float)12.0f, (float)0.1f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(WitherSkeletonKnight witherSkeletonKnight, float pitch, float yaw, float roll) {
        this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        ItemStack itemstack = witherSkeletonKnight.getItemInHand(InteractionHand.MAIN_HAND);
        if (itemstack.is(Items.BOW) && witherSkeletonKnight.isAggressive()) {
            if (witherSkeletonKnight.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        super.prepareMobModel((LivingEntity)witherSkeletonKnight, pitch, yaw, roll);
    }

    public void setupAnim(WitherSkeletonKnight witherSkeletonKnight, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)witherSkeletonKnight, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ItemStack itemstack = witherSkeletonKnight.getMainHandItem();
        if (witherSkeletonKnight.isAggressive() && (itemstack.isEmpty() || !itemstack.is(Items.BOW))) {
            float f = Mth.sin((float)(this.attackTime * (float)Math.PI));
            float f1 = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * (float)Math.PI));
            this.rightArm.zRot = 0.0f;
            this.leftArm.zRot = 0.0f;
            this.rightArm.yRot = -(0.1f - f * 0.6f);
            this.leftArm.yRot = 0.1f - f * 0.6f;
            this.rightArm.xRot = -1.5707964f;
            this.leftArm.xRot = -1.5707964f;
            this.rightArm.xRot -= f * 1.2f - f1 * 0.4f;
            this.leftArm.xRot -= f * 1.2f - f1 * 0.4f;
            AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
        }
        if (witherSkeletonKnight.isAlive() && witherSkeletonKnight.isUsingShield()) {
            boolean flag = witherSkeletonKnight.getMainArm() == HumanoidArm.RIGHT;
            if (witherSkeletonKnight.getShieldHand() == InteractionHand.MAIN_HAND == flag) {
                this.poseRightArmShield();
            } else if (witherSkeletonKnight.getShieldHand() == InteractionHand.OFF_HAND == flag) {
                this.poseLeftArmShield();
            }
        }
    }

    private void poseRightArmShield() {
        this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.9424779f + 0.7853982f;
        this.rightArm.yRot = -0.5235988f;
    }

    private void poseLeftArmShield() {
        this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.9424779f + 0.7853982f;
        this.leftArm.yRot = 0.5235988f;
    }

    public void translateToHand(HumanoidArm arm, PoseStack pose) {
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart modelpart = this.getArm(arm);
        modelpart.x += f;
        modelpart.translateAndRotate(pose);
        modelpart.x -= f;
    }
}

