/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.betterpingdisplay.client;

import com.vladmarica.betterpingdisplay.client.ColorUtil;
import net.minecraft.util.Mth;

public final class PingColors {
    public static final int PING_START = 0;
    public static final int PING_MID = 150;
    public static final int PING_END = 300;
    public static final int COLOR_GREY = 0x535353;
    public static final int COLOR_START = 58998;
    public static final int COLOR_MID = 14077232;
    public static final int COLOR_END = 15022389;

    public static int getColor(int ping) {
        if (ping < 0) {
            return 0x535353;
        }
        if (ping < 150) {
            return ColorUtil.interpolate(58998, 14077232, PingColors.computeOffset(0, 150, ping));
        }
        return ColorUtil.interpolate(14077232, 15022389, PingColors.computeOffset(150, 300, Math.min(ping, 300)));
    }

    private static float computeOffset(int start, int end, int value) {
        float offset = (float)(value - start) / (float)(end - start);
        return Mth.clamp((float)offset, (float)0.0f, (float)1.0f);
    }

    private PingColors() {
    }
}

