/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.recipe;

import dev.xkmc.cuisinedelight.content.item.BaseFoodItem;
import dev.xkmc.cuisinedelight.content.logic.CookedFoodData;
import dev.xkmc.cuisinedelight.content.recipe.CuisineRecipeContainer;
import dev.xkmc.cuisinedelight.content.recipe.CuisineRecipeMatch;
import dev.xkmc.cuisinedelight.init.registrate.CDMisc;
import dev.xkmc.l2core.serial.recipe.BaseRecipe;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

@SerialClass
public class BaseCuisineRecipe<R extends BaseCuisineRecipe<R>>
extends BaseRecipe<R, BaseCuisineRecipe<?>, CuisineRecipeContainer> {
    @SerialField
    public final ArrayList<CuisineRecipeMatch> list = new ArrayList();
    @SerialField
    public double saturationBonus;
    @SerialField
    public double saturationBonusModifier;
    @SerialField
    public Item holderItem;

    public static ItemStack findBestMatch(Level level, CookedFoodData food) {
        CuisineRecipeContainer inv = new CuisineRecipeContainer(food);
        List list = level.getRecipeManager().getRecipesFor((RecipeType)CDMisc.RT_CUISINE.get(), (RecipeInput)inv, level);
        BaseCuisineRecipe ans = null;
        double score = -1.0;
        for (RecipeHolder r : list) {
            double s = ((BaseCuisineRecipe)r.value()).getScore(inv);
            if (!(s > score)) continue;
            score = s;
            ans = (BaseCuisineRecipe)r.value();
        }
        assert (ans != null);
        ItemStack result = ans.assemble(inv, (HolderLookup.Provider)level.registryAccess());
        food = food.saturationBonus(1.0 + ans.saturationBonusModifier * (score -= ans.getScoreOffset()));
        BaseFoodItem.setData(result, food);
        return result;
    }

    public BaseCuisineRecipe(BaseRecipe.RecType<R, BaseCuisineRecipe<?>, CuisineRecipeContainer> fac) {
        super(fac);
    }

    public boolean matches(CuisineRecipeContainer cont, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(cont.list);
        for (CuisineRecipeMatch match : this.list) {
            if (match.reduce(inputs) != 0.0) continue;
            return false;
        }
        return true;
    }

    public double getScore(CuisineRecipeContainer cont) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(cont.list);
        double ans = 0.0;
        for (CuisineRecipeMatch match : this.list) {
            ans += match.reduce(inputs);
        }
        return ans;
    }

    public ItemStack assemble(CuisineRecipeContainer cont, HolderLookup.Provider access) {
        return this.holderItem.getDefaultInstance();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider access) {
        Item item = this.holderItem;
        if (item instanceof BaseFoodItem) {
            BaseFoodItem food = (BaseFoodItem)item;
            return food.displayStack(this);
        }
        return this.holderItem.getDefaultInstance();
    }

    private double getScoreOffset() {
        double ans = 0.0;
        for (CuisineRecipeMatch e : this.list) {
            ans += e.score();
        }
        return ans;
    }

    public double getMinSaturationBonus() {
        return this.saturationBonus;
    }

    public double getMaxSaturationBonus() {
        double ans = this.saturationBonus;
        for (CuisineRecipeMatch e : this.list) {
            ans += this.saturationBonusModifier * e.bonus();
        }
        return ans;
    }
}

