/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.item;

import dev.xkmc.cuisinedelight.content.logic.CookedFoodData;
import dev.xkmc.cuisinedelight.content.logic.JEIDisplayInfo;
import dev.xkmc.cuisinedelight.content.recipe.BaseCuisineRecipe;
import dev.xkmc.cuisinedelight.content.recipe.CuisineRecipeContainer;
import dev.xkmc.cuisinedelight.events.FoodEatenEvent;
import dev.xkmc.cuisinedelight.init.data.LangData;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.Configuration;

public class BaseFoodItem
extends Item {
    public static ItemStack setResultDisplay(BaseCuisineRecipe<?> recipe, ItemStack stack) {
        return CDItems.DISPLAY.set(stack, (Object)new JEIDisplayInfo(recipe.getMinSaturationBonus(), recipe.getMaxSaturationBonus()));
    }

    public static ItemStack setIngredientDisplay(ItemStack stack) {
        return CDItems.INGREDIENT.set(stack, (Object)Unit.INSTANCE);
    }

    public ItemStack displayStack(BaseCuisineRecipe<?> recipe) {
        return CDItems.DISPLAY.set(this.getDefaultInstance(), (Object)new JEIDisplayInfo(recipe.getMinSaturationBonus(), recipe.getMaxSaturationBonus()));
    }

    @Nullable
    public static CookedFoodData getData(ItemStack stack) {
        return (CookedFoodData)CDItems.COOKED.get(stack);
    }

    public static void setData(ItemStack stack, @Nullable CookedFoodData data) {
        if (data == null) {
            stack.remove((DataComponentType)CDItems.COOKED.get());
        } else {
            CDItems.COOKED.set(stack, (Object)data);
        }
    }

    public BaseFoodItem(Item.Properties properties) {
        super(properties);
    }

    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        CookedFoodData data = BaseFoodItem.getData(stack);
        if (data == null) {
            return null;
        }
        return data.toFoodData();
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        CookedFoodData food = BaseFoodItem.getData(stack);
        super.finishUsingItem(stack, level, entity);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (food != null) {
                NeoForge.EVENT_BUS.post((Event)new FoodEatenEvent(player, food));
            }
        }
        if (food == null) {
            return this.getCraftingRemainingItem(stack);
        }
        if ((food = food.shrink()).size() <= 0) {
            return this.getCraftingRemainingItem(stack);
        }
        stack.setCount(1);
        BaseFoodItem.setData(stack, food);
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        CookedFoodData data = BaseFoodItem.getData(stack);
        if (data == null || data.score() < 60) {
            return 72000;
        }
        return super.getUseDuration(stack, entity);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        int level;
        BlockPos pos = ctx.getClickedPos();
        BlockState state = ctx.getLevel().getBlockState(pos);
        ItemStack stack = ctx.getItemInHand();
        if (state.is(Blocks.COMPOSTER) && (level = ((Integer)state.getValue((Property)ComposterBlock.LEVEL)).intValue()) < 7) {
            CookedFoodData data;
            if (!ctx.getLevel().isClientSide() && (data = BaseFoodItem.getData(stack)) != null && data.size() > 0) {
                if (ctx.getPlayer() == null || !ctx.getPlayer().getAbilities().instabuild) {
                    data = data.shrink();
                    BaseFoodItem.setData(stack, data);
                }
                if (ctx.getLevel().getRandom().nextDouble() < (double)0.3f) {
                    BlockState newState = (BlockState)state.setValue((Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(level + 1));
                    ctx.getLevel().setBlockAndUpdate(pos, newState);
                    if (level + 1 == 7) {
                        ctx.getLevel().scheduleTick(pos, state.getBlock(), 20);
                    }
                    ctx.getLevel().gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)ctx.getPlayer(), (BlockState)newState));
                    ctx.getLevel().levelEvent(1500, pos, 1);
                } else {
                    ctx.getLevel().levelEvent(1500, pos, 0);
                }
                if (data.size() == 0) {
                    ItemStack remain = this.getCraftingRemainingItem(stack);
                    stack.shrink(1);
                    if (ctx.getPlayer() != null) {
                        ctx.getPlayer().getInventory().placeItemBackInInventory(remain);
                    } else {
                        Block.dropResources((BlockState)state, (Level)ctx.getLevel(), (BlockPos)ctx.getClickedPos(), null, null, (ItemStack)remain);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        JEIDisplayInfo disp = (JEIDisplayInfo)CDItems.DISPLAY.get(stack);
        if (disp != null) {
            list.add((Component)LangData.INFO_DISPLAY.get(disp.min(), disp.max()));
            return;
        }
        CookedFoodData data = BaseFoodItem.getData(stack);
        if (data == null) {
            list.add((Component)LangData.CREATIVE.get(new Object[0]));
            return;
        }
        FoodProperties prop = data.toFoodData();
        if (prop == CookedFoodData.BAD) {
            list.add((Component)LangData.BAD_FOOD.get(new Object[0]));
        } else {
            list.add((Component)LangData.SERVE_SIZE.get(data.size()));
            list.add((Component)LangData.SCORE.get(data.score()));
        }
        if (Screen.hasShiftDown()) {
            for (CookedFoodData.Entry entry : data.entries()) {
                ItemStack ingredient = entry.stack();
                if (entry.burnt()) {
                    list.add((Component)LangData.BAD_BURNT.get(ingredient.getHoverName()));
                }
                if (entry.raw()) {
                    list.add((Component)LangData.BAD_RAW.get(ingredient.getHoverName()));
                }
                if (entry.overcooked()) {
                    list.add((Component)LangData.BAD_OVERCOOKED.get(ingredient.getHoverName()));
                }
                if (entry.burnt() || entry.raw() || entry.overcooked()) continue;
                list.add((Component)LangData.GOOD.get(ingredient.getHoverName()));
            }
        } else {
            list.add((Component)LangData.SHIFT.get(new Object[0]));
            CuisineRecipeContainer cont = new CuisineRecipeContainer(data);
            for (ItemStack e : cont.list) {
                if (e.isEmpty()) continue;
                double perc = (double)Math.round(1000.0 * (double)e.getCount() / (double)data.total()) / 10.0;
                list.add((Component)e.getHoverName().copy().append(": " + perc + "%"));
            }
        }
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            for (FoodProperties.PossibleEffect possibleEffect : prop.effects()) {
                MobEffectInstance mobeffectinstance = possibleEffect.effect();
                MutableComponent mutablecomponent = Component.translatable((String)mobeffectinstance.getDescriptionId());
                Holder mobeffect = mobeffectinstance.getEffect();
                if (mobeffectinstance.getAmplifier() > 0) {
                    mutablecomponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.translatable((String)("potion.potency." + mobeffectinstance.getAmplifier()))});
                }
                if (mobeffectinstance.getDuration() > 20) {
                    mutablecomponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.formatDuration((MobEffectInstance)mobeffectinstance, (float)1.0f, (float)20.0f)});
                }
                list.add((Component)mutablecomponent.withStyle(((MobEffect)mobeffect.value()).getCategory().getTooltipFormatting()));
            }
        }
    }
}

