/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;

public class FluidRenderer {
    public static VertexConsumer getFluidBuilder(MultiBufferSource buffer) {
        return buffer.getBuffer(RenderTypes.FLUID);
    }

    public static void renderWaterBox(float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int light, int colorOverride) {
        FluidRenderer.renderFluidBox(new FluidStack((Fluid)Fluids.WATER, 1000), xMin, yMin, zMin, xMax, yMax, zMax, buffer, ms, light, false, colorOverride);
    }

    public static void renderFluidBox(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int light, boolean renderBottom, int colorOverride) {
        FluidRenderer.renderFluidBox(fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, FluidRenderer.getFluidBuilder(buffer), ms, light, renderBottom, colorOverride);
    }

    public static void renderFluidBox(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack ms, int light, boolean renderBottom, int colorOverride) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid);
        FluidType fluidAttributes = fluid.getFluidType();
        TextureAtlasSprite fluidTexture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(clientFluid.getStillTexture(fluidStack));
        int color = clientFluid.getTintColor(fluidStack);
        if (colorOverride != 0) {
            color = colorOverride;
        }
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluidAttributes.getLightLevel(fluidStack));
        light = light & 0xF00000 | luminosity << 4;
        ms.pushPose();
        for (Direction side : Direction.values()) {
            boolean positive;
            if (side == Direction.DOWN && !renderBottom) continue;
            boolean bl = positive = side.getAxisDirection() == Direction.AxisDirection.POSITIVE;
            if (side.getAxis().isHorizontal()) {
                if (side.getAxis() == Direction.Axis.X) {
                    FluidRenderer.renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, ms, light, color, fluidTexture);
                    continue;
                }
                FluidRenderer.renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, ms, light, color, fluidTexture);
                continue;
            }
            FluidRenderer.renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, ms, light, color, fluidTexture);
        }
        ms.popPose();
    }

    public static void renderStillTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        FluidRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 1.0f);
    }

    public static void renderTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture, float textureScale) {
        boolean positive = dir.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        boolean horizontal = dir.getAxis().isHorizontal();
        boolean x = dir.getAxis() == Direction.Axis.X;
        float shrink = texture.uvShrinkRatio() * 0.25f * textureScale;
        float centerU = texture.getU0() + (texture.getU1() - texture.getU0()) * 0.5f * textureScale;
        float centerV = texture.getV0() + (texture.getV1() - texture.getV0()) * 0.5f * textureScale;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float x1 = left;
        while (x1 < right) {
            float u2;
            float u1;
            float f = Mth.floor((float)x1);
            x2 = Math.min(f + 1.0f, right);
            if (dir != Direction.NORTH && dir != Direction.EAST) {
                u1 = texture.getU((x1 - f) * 16.0f * textureScale);
                u2 = texture.getU((x2 - f) * 16.0f * textureScale);
            } else {
                f = Mth.ceil((float)x2);
                u1 = texture.getU((f - x2) * 16.0f * textureScale);
                u2 = texture.getU((f - x1) * 16.0f * textureScale);
            }
            u1 = Mth.lerp((float)shrink, (float)u1, (float)centerU);
            u2 = Mth.lerp((float)shrink, (float)u2, (float)centerU);
            float y1 = down;
            while (y1 < up) {
                float v2;
                float v1;
                f = Mth.floor((float)y1);
                y2 = Math.min(f + 1.0f, up);
                if (dir == Direction.UP) {
                    v1 = texture.getV((y1 - f) * 16.0f * textureScale);
                    v2 = texture.getV((y2 - f) * 16.0f * textureScale);
                } else {
                    f = Mth.ceil((float)y2);
                    v1 = texture.getV((f - y2) * 16.0f * textureScale);
                    v2 = texture.getV((f - y1) * 16.0f * textureScale);
                }
                v1 = Mth.lerp((float)shrink, (float)v1, (float)centerV);
                v2 = Mth.lerp((float)shrink, (float)v2, (float)centerV);
                if (horizontal) {
                    if (x) {
                        FluidRenderer.putVertex(builder, ms, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        FluidRenderer.putVertex(builder, ms, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    FluidRenderer.putVertex(builder, ms, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    FluidRenderer.putVertex(builder, ms, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    FluidRenderer.putVertex(builder, ms, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    FluidRenderer.putVertex(builder, ms, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
                y1 = y2;
            }
            x1 = x2;
        }
    }

    private static void putVertex(VertexConsumer builder, PoseStack ms, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vec3i normal = face.getNormal();
        PoseStack.Pose peek = ms.last();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.addVertex(peek.pose(), x, y, z).setColor(r, g, b, a).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(peek, (float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
    }

    private static class RenderTypes
    extends RenderStateShard {
        private static final RenderType FLUID = RenderType.create((String)RenderTypes.createLayerName("fluid"), (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_TRANSLUCENT_CULL_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(true));

        private static String createLayerName(String name) {
            return "cuisinedelight:" + name;
        }

        public RenderTypes(String p_110161_, Runnable p_110162_, Runnable p_110163_) {
            super(p_110161_, p_110162_, p_110163_);
        }
    }
}

