/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.block;

import dev.xkmc.cuisinedelight.content.item.CuisineSkilletItem;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import dev.xkmc.l2core.base.tile.BaseBlockEntity;
import dev.xkmc.l2core.init.reg.ench.EnchHelper;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;

@SerialClass
public class CuisineSkilletBlockEntity
extends BaseBlockEntity
implements HeatableBlockEntity {
    @SerialField
    public ItemStack baseItem = CDItems.SKILLET.asStack();
    @Nonnull
    @SerialField
    public CookingData cookingData = new CookingData();
    @SerialField
    private int stirTimer = 0;

    public CuisineSkilletBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.stirTimer > 0) {
            --this.stirTimer;
        }
    }

    public boolean isCooking() {
        return !this.cookingData.contents.isEmpty();
    }

    public NonNullList<ItemStack> getItems() {
        return NonNullList.create();
    }

    public void setSkilletItem(ItemStack stack) {
        this.baseItem = stack.copy();
        CookingData data = CuisineSkilletItem.getData(stack);
        if (data != null) {
            this.cookingData = data;
        }
        CuisineSkilletItem.setData(this.baseItem, null);
        this.sync();
    }

    public ItemStack toItemStack() {
        ItemStack ans = this.baseItem.copy();
        if (!this.cookingData.contents.isEmpty()) {
            CuisineSkilletItem.setData(ans, this.cookingData);
        }
        return ans;
    }

    public boolean canCook() {
        return this.level != null && this.isHeated(this.level, this.getBlockPos()) || EnchHelper.getLv((ItemStack)this.baseItem, (ResourceKey)Enchantments.FIRE_ASPECT) > 0;
    }

    public boolean slowCook() {
        return EnchHelper.getLv((ItemStack)this.baseItem, (ResourceKey)Enchantments.FIRE_ASPECT) == 1 && this.level != null && !this.isHeated(this.level, this.getBlockPos());
    }

    public float getStirPercent(float pTick) {
        return Math.max(0.0f, (float)this.stirTimer - pTick) / 20.0f;
    }

    public void stir(long gameTime, int reduce) {
        this.cookingData.stir(gameTime, reduce);
        this.stirTimer = 20;
        this.sync();
    }
}

