/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.network;

import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketFurnaceSettings(int x, int y, int z, int index, int set) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"furnace_settings_packet");
    public static final CustomPacketPayload.Type<PacketFurnaceSettings> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketFurnaceSettings> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PacketFurnaceSettings::x, (StreamCodec)ByteBufCodecs.INT, PacketFurnaceSettings::y, (StreamCodec)ByteBufCodecs.INT, PacketFurnaceSettings::z, (StreamCodec)ByteBufCodecs.INT, PacketFurnaceSettings::index, (StreamCodec)ByteBufCodecs.INT, PacketFurnaceSettings::set, PacketFurnaceSettings::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static PacketFurnaceSettings create(int x, int y, int z, int index, int set) {
        return new PacketFurnaceSettings(x, y, z, index, set);
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            BlockPos pos = new BlockPos(this.x, this.y, this.z);
            BlockIronFurnaceTileBase te = (BlockIronFurnaceTileBase)player.level().getBlockEntity(pos);
            if (player.level().isLoaded(pos)) {
                te.furnaceSettings.set(this.index, this.set);
                te.getLevel().markAndNotifyBlock(pos, player.level().getChunkAt(pos), te.getLevel().getBlockState(pos).getBlock().defaultBlockState(), te.getLevel().getBlockState(pos), 2, 0);
                te.setChanged();
            }
        });
    }
}

