/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.jei;

import com.google.common.collect.Lists;
import ironfurnaces.init.Registration;
import ironfurnaces.jei.RecipeCategoryGeneratorBlasting;
import ironfurnaces.jei.RecipeCategoryGeneratorRegular;
import ironfurnaces.jei.RecipeCategoryGeneratorSmoking;
import ironfurnaces.recipes.GeneratorRecipe;
import ironfurnaces.recipes.SimpleGeneratorRecipe;
import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.EventHooks;

@JeiPlugin
public class IronFurnacesJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"plugin_ironfurnaces");
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new RecipeCategoryGeneratorBlasting(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RecipeCategoryGeneratorSmoking(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RecipeCategoryGeneratorRegular(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList recipes = Lists.newArrayList();
        for (Item item : BuiltInRegistries.ITEM.stream().toList()) {
            int burntime = EventHooks.getItemBurnTime((ItemStack)new ItemStack((ItemLike)item), (int)item.getBurnTime(new ItemStack((ItemLike)item), net.minecraft.world.item.crafting.RecipeType.SMELTING), (net.minecraft.world.item.crafting.RecipeType)net.minecraft.world.item.crafting.RecipeType.SMELTING);
            if (burntime <= 0) continue;
            ItemStack stack = new ItemStack((ItemLike)item);
            recipes.add(new SimpleGeneratorRecipe(burntime * 20, stack));
        }
        registration.addRecipes(Registration.RecipeTypes.GENERATOR_REGULAR, (List)recipes);
        ArrayList recipes1 = Lists.newArrayList();
        List list = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(Registration.GENERATOR_RECIPE_TYPE.get()).stream().toList();
        for (RecipeHolder item : list) {
            recipes1.add((GeneratorRecipe)item.value());
        }
        registration.addRecipes(Registration.RecipeTypes.GENERATOR_BLASTING, (List)recipes1);
        ArrayList recipes2 = Lists.newArrayList();
        for (Item item : BuiltInRegistries.ITEM.stream().toList()) {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (stack.get(DataComponents.FOOD) == null || ((FoodProperties)stack.get(DataComponents.FOOD)).nutrition() <= 0) continue;
            recipes2.add(new SimpleGeneratorRecipe(BlockIronFurnaceTileBase.getSmokingBurn(stack) * 40, stack));
        }
        registration.addRecipes(Registration.RecipeTypes.GENERATOR_SMOKING, (List)recipes2);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.BLASTING_AUGMENT.get()), new RecipeType[]{RecipeTypes.BLASTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.SMOKING_AUGMENT.get()), new RecipeType[]{RecipeTypes.SMOKING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GENERATOR_AUGMENT.get()), new RecipeType[]{Registration.RecipeTypes.GENERATOR_REGULAR});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GENERATOR_AUGMENT.get()), new RecipeType[]{Registration.RecipeTypes.GENERATOR_BLASTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GENERATOR_AUGMENT.get()), new RecipeType[]{Registration.RecipeTypes.GENERATOR_SMOKING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.FACTORY_AUGMENT.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.IRON_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GOLD_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.DIAMOND_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.EMERALD_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.OBSIDIAN_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.CRYSTAL_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.NETHERITE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.COPPER_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.SILVER_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.MILLION_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.IRON_FURNACE.get()), new RecipeType[]{RecipeTypes.FUELING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GOLD_FURNACE.get()), new RecipeType[]{RecipeTypes.FUELING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.DIAMOND_FURNACE.get()), new RecipeType[]{RecipeTypes.FUELING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.EMERALD_FURNACE.get()), new RecipeType[]{RecipeTypes.FUELING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.OBSIDIAN_FURNACE.get()), new RecipeType[]{RecipeTypes.FUELING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.CRYSTAL_FURNACE.get()), new RecipeType[]{RecipeTypes.FUELING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.NETHERITE_FURNACE.get()), new RecipeType[]{RecipeTypes.FUELING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.COPPER_FURNACE.get()), new RecipeType[]{RecipeTypes.FUELING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.SILVER_FURNACE.get()), new RecipeType[]{RecipeTypes.FUELING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.MILLION_FURNACE.get()), new RecipeType[]{RecipeTypes.FUELING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.BLASTING_AUGMENT.get()), new RecipeType[]{Registration.RecipeTypes.GENERATOR_BLASTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.SMOKING_AUGMENT.get()), new RecipeType[]{Registration.RecipeTypes.GENERATOR_SMOKING});
        if (ModList.get().isLoaded("allthemodium")) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.ALLTHEMODIUM_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.VIBRANIUM_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.UNOBTAINIUM_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.ALLTHEMODIUM_FURNACE.get()), new RecipeType[]{RecipeTypes.FUELING});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.VIBRANIUM_FURNACE.get()), new RecipeType[]{RecipeTypes.FUELING});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.UNOBTAINIUM_FURNACE.get()), new RecipeType[]{RecipeTypes.FUELING});
        }
    }
}

