/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.container.furnaces;

import ironfurnaces.container.slots.SlotIronFurnace;
import ironfurnaces.container.slots.SlotIronFurnaceAugmentBlue;
import ironfurnaces.container.slots.SlotIronFurnaceAugmentGreen;
import ironfurnaces.container.slots.SlotIronFurnaceAugmentRed;
import ironfurnaces.container.slots.SlotIronFurnaceFuel;
import ironfurnaces.container.slots.SlotIronFurnaceInput;
import ironfurnaces.container.slots.SlotIronFurnaceInputFactory;
import ironfurnaces.container.slots.SlotIronFurnaceInputGenerator;
import ironfurnaces.container.slots.SlotIronFurnaceOutputFactory;
import ironfurnaces.items.ItemHeater;
import ironfurnaces.items.augments.ItemAugmentBlasting;
import ironfurnaces.items.augments.ItemAugmentSmoking;
import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase;
import ironfurnaces.util.container.FactoryDataSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public abstract class BlockIronFurnaceContainerBase
extends AbstractContainerMenu {
    protected BlockIronFurnaceTileBase te;
    protected Player playerEntity;
    protected IItemHandler playerInventory;
    protected final Level world;

    public BlockIronFurnaceContainerBase(MenuType<?> containerType, int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player) {
        super(containerType, windowId);
        this.te = (BlockIronFurnaceTileBase)world.getBlockEntity(pos);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.world = playerInventory.player.level();
        this.addSlot(new SlotIronFurnaceInput(this.te, 0, 56, 17));
        this.addSlot(new SlotIronFurnaceFuel(this.te, 1, 56, 53));
        this.addSlot(new SlotIronFurnace(this.playerEntity, this.te, 2, 116, 35));
        this.addSlot(new SlotIronFurnaceAugmentRed(this.te, 3, 26, 35));
        this.addSlot(new SlotIronFurnaceAugmentGreen(this.te, 4, 80, 35));
        this.addSlot(new SlotIronFurnaceAugmentBlue(this.te, 5, 134, 35));
        this.addSlot(new SlotIronFurnaceInputGenerator(this.te, 6, 56, 40));
        this.addSlot(new SlotIronFurnaceInputFactory(0, this.te, 7, 28, 6));
        this.addSlot(new SlotIronFurnaceInputFactory(1, this.te, 8, 49, 6));
        this.addSlot(new SlotIronFurnaceInputFactory(2, this.te, 9, 70, 6));
        this.addSlot(new SlotIronFurnaceInputFactory(3, this.te, 10, 91, 6));
        this.addSlot(new SlotIronFurnaceInputFactory(4, this.te, 11, 112, 6));
        this.addSlot(new SlotIronFurnaceInputFactory(5, this.te, 12, 133, 6));
        this.addSlot(new SlotIronFurnaceOutputFactory(0, this.playerEntity, this.te, 13, 28, 55));
        this.addSlot(new SlotIronFurnaceOutputFactory(1, this.playerEntity, this.te, 14, 49, 55));
        this.addSlot(new SlotIronFurnaceOutputFactory(2, this.playerEntity, this.te, 15, 70, 55));
        this.addSlot(new SlotIronFurnaceOutputFactory(3, this.playerEntity, this.te, 16, 91, 55));
        this.addSlot(new SlotIronFurnaceOutputFactory(4, this.playerEntity, this.te, 17, 112, 55));
        this.addSlot(new SlotIronFurnaceOutputFactory(5, this.playerEntity, this.te, 18, 133, 55));
        this.layoutPlayerInventorySlots(8, 84);
        BlockIronFurnaceContainerBase.checkContainerSize((Container)this.te, (int)19);
        this.addDataSlots();
    }

    public void addDataSlots() {
        this.addDataSlot(new DataSlot(){

            public int get() {
                return BlockIronFurnaceContainerBase.this.getAugmentGUI() ? 1 : 0;
            }

            public void set(int value) {
                BlockIronFurnaceContainerBase.this.te.furnaceSettings.set(10, value);
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return BlockIronFurnaceContainerBase.this.getIsFurnace() ? 1 : 0;
            }

            public void set(int value) {
                if (value == 1) {
                    BlockIronFurnaceContainerBase.this.te.currentAugment[2] = 0;
                }
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return BlockIronFurnaceContainerBase.this.getIsGenerator() ? 1 : 0;
            }

            public void set(int value) {
                if (value == 1) {
                    BlockIronFurnaceContainerBase.this.te.currentAugment[2] = 2;
                }
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return BlockIronFurnaceContainerBase.this.getIsFactory() ? 1 : 0;
            }

            public void set(int value) {
                if (value == 1) {
                    BlockIronFurnaceContainerBase.this.te.currentAugment[2] = 1;
                }
            }
        });
        this.addEnergyData();
        this.addFurnaceData();
        this.addGeneratorData();
        this.addFactoryData();
    }

    public void addFurnaceData() {
        this.addDataSlot(new DataSlot(){

            public int get() {
                return BlockIronFurnaceContainerBase.this.te.furnaceBurnTime;
            }

            public void set(int value) {
                BlockIronFurnaceContainerBase.this.te.furnaceBurnTime = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return BlockIronFurnaceContainerBase.this.te.recipesUsed;
            }

            public void set(int value) {
                int add = BlockIronFurnaceContainerBase.this.te.recipesUsed;
                BlockIronFurnaceContainerBase.this.te.recipesUsed = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return BlockIronFurnaceContainerBase.this.te.cookTime;
            }

            public void set(int value) {
                BlockIronFurnaceContainerBase.this.te.cookTime = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return BlockIronFurnaceContainerBase.this.te.totalCookTime;
            }

            public void set(int value) {
                BlockIronFurnaceContainerBase.this.te.totalCookTime = value;
            }
        });
    }

    public void addGeneratorData() {
        this.addDataSlot(new DataSlot(){

            public int get() {
                return (int)BlockIronFurnaceContainerBase.this.te.generatorBurn;
            }

            public void set(int value) {
                BlockIronFurnaceContainerBase.this.te.generatorBurn = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return BlockIronFurnaceContainerBase.this.te.generatorRecentRecipeRF;
            }

            public void set(int value) {
                BlockIronFurnaceContainerBase.this.te.generatorRecentRecipeRF = value;
            }
        });
    }

    public void addFactoryData() {
        int i;
        for (i = 0; i < this.te.factoryCookTime.length; ++i) {
            this.addDataSlot(new FactoryDataSlot(i){

                public int get() {
                    return BlockIronFurnaceContainerBase.this.te.factoryCookTime[this.index];
                }

                public void set(int value) {
                    BlockIronFurnaceContainerBase.this.te.factoryCookTime[this.index] = value;
                }
            });
        }
        for (i = 0; i < this.te.factoryTotalCookTime.length; ++i) {
            this.addDataSlot(new FactoryDataSlot(i){

                public int get() {
                    return BlockIronFurnaceContainerBase.this.te.factoryTotalCookTime[this.index];
                }

                public void set(int value) {
                    BlockIronFurnaceContainerBase.this.te.factoryTotalCookTime[this.index] = value;
                }
            });
        }
    }

    public int getEnergy() {
        return this.te.getEnergy();
    }

    public int getMaxEnergy() {
        return this.te.energyStorage.getMaxEnergyStored();
    }

    private void addEnergyData() {
        this.addDataSlot(new DataSlot(){

            public int get() {
                return BlockIronFurnaceContainerBase.this.getMaxEnergy();
            }

            public void set(int value) {
                BlockIronFurnaceContainerBase.this.te.setMaxEnergy(value);
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return BlockIronFurnaceContainerBase.this.getEnergy();
            }

            public void set(int value) {
                BlockIronFurnaceContainerBase.this.te.setEnergy(value);
            }
        });
    }

    public boolean stillValid(Player player) {
        return this.te.stillValid(player);
    }

    public int getTier() {
        return this.te.getTier();
    }

    public boolean isAutoSplit() {
        return this.te.isAutoSplit();
    }

    public int getRedstoneMode() {
        return this.te.getRedstoneSetting();
    }

    public int getComSub() {
        return this.te.getRedstoneComSub();
    }

    public boolean getAutoInput() {
        return this.te.getAutoInput() == 1;
    }

    public boolean getAugmentGUI() {
        return this.te.getAugmentGUI() == 1;
    }

    public boolean getIsFactory() {
        return this.te.isFactory();
    }

    public boolean getIsFurnace() {
        return this.te.isFurnace();
    }

    public boolean getIsGenerator() {
        return this.te.isGenerator();
    }

    public boolean getAutoOutput() {
        return this.te.getAutoOutput() == 1;
    }

    public Component getTooltip(int index) {
        switch (this.te.furnaceSettings.get(index)) {
            case 1: {
                return Component.translatable((String)"tooltip.ironfurnaces.gui_input");
            }
            case 2: {
                return Component.translatable((String)"tooltip.ironfurnaces.gui_output");
            }
            case 3: {
                return Component.translatable((String)"tooltip.ironfurnaces.gui_input_output");
            }
            case 4: {
                return Component.translatable((String)"tooltip.ironfurnaces.gui_fuel");
            }
        }
        return Component.translatable((String)"tooltip.ironfurnaces.gui_none");
    }

    public int getSettingTop() {
        return this.te.getSettingTop();
    }

    public int getSettingBottom() {
        return this.te.getSettingBottom();
    }

    public int getSettingFront() {
        return this.te.getSettingFront();
    }

    public int getSettingBack() {
        return this.te.getSettingBack();
    }

    public int getSettingLeft() {
        return this.te.getSettingLeft();
    }

    public int getSettingRight() {
        return this.te.getSettingRight();
    }

    public int getIndexFront() {
        return this.te.getIndexFront();
    }

    public int getIndexBack() {
        return this.te.getIndexBack();
    }

    public int getIndexLeft() {
        return this.te.getIndexLeft();
    }

    public int getIndexRight() {
        return this.te.getIndexRight();
    }

    public BlockPos getPos() {
        return this.te.getBlockPos();
    }

    public boolean isBurning() {
        return this.te.isBurning();
    }

    public boolean isRainbowFurnace() {
        return this.te.isRainbowFurnace();
    }

    public int getCookScaled(int pixels) {
        int i = this.te.cookTime;
        int j = this.te.totalCookTime;
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getFactoryCookScaled(int index, int pixels) {
        int i = this.te.factoryCookTime[index];
        int j = this.te.factoryTotalCookTime[index];
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getFactoryCooktimeSize() {
        return this.te.factoryCookTime.length;
    }

    public int getBurnLeftScaled(int pixels) {
        int i = this.te.recipesUsed;
        if (i == 0) {
            i = 200;
        }
        return this.te.furnaceBurnTime * pixels / i;
    }

    public int getGeneratorBurnScaled(int pixels) {
        int i = this.te.generatorRecentRecipeRF;
        if (i == 0) {
            i = 200;
        }
        return (int)this.te.generatorBurn * pixels / i;
    }

    public boolean isGeneratorBurning() {
        return this.te.generatorBurn > 0.0;
    }

    public int getEnergyScaled(int pixels) {
        int i = this.te.getEnergy();
        int j = this.te.getCapacity();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (this.te.isGenerator()) {
                if (index != 6 && index != 3 && index != 4 && index != 5) {
                    if (this.te.getItem(3).getItem() instanceof ItemAugmentSmoking) {
                        if (BlockIronFurnaceTileBase.getSmokingBurn(itemstack1) > 0 && (itemstack1.hasCraftingRemainingItem() ? this.te.getItem(6).isEmpty() && !this.specialMoveItemStackTo(itemstack1, 6, 7, false) : !this.moveItemStackTo(itemstack1, 6, 7, false))) {
                            return ItemStack.EMPTY;
                        }
                    } else if (this.te.getItem(3).getItem() instanceof ItemAugmentBlasting ? this.te.hasGeneratorBlastingRecipe(itemstack1) && !this.moveItemStackTo(itemstack1, 6, 7, false) : BlockIronFurnaceTileBase.isItemFuel(itemstack1, RecipeType.SMELTING) && !(itemstack1.getItem() instanceof ItemHeater) && !this.moveItemStackTo(itemstack1, 6, 7, false)) {
                        return ItemStack.EMPTY;
                    }
                    if (BlockIronFurnaceTileBase.isItemAugment(itemstack1, 0) ? !this.moveItemStackTo(itemstack1, 3, 4, false) : (BlockIronFurnaceTileBase.isItemAugment(itemstack1, 1) ? !this.moveItemStackTo(itemstack1, 4, 5, false) : (BlockIronFurnaceTileBase.isItemAugment(itemstack1, 2) ? !this.moveItemStackTo(itemstack1, 5, 6, false) : (index >= 19 && index <= 45 ? !this.moveItemStackTo(itemstack1, 46, 55, false) : index >= 45 && index < 55 && !this.moveItemStackTo(itemstack1, 19, 46, false))))) {
                        return ItemStack.EMPTY;
                    }
                } else if (!this.moveItemStackTo(itemstack1, 19, 55, false)) {
                    return ItemStack.EMPTY;
                }
            }
            if (this.te.isFactory()) {
                if (index > 12 && index <= 18) {
                    if (!this.moveItemStackTo(itemstack1, 19, 55, true)) {
                        return ItemStack.EMPTY;
                    }
                    slot.onQuickCraft(itemstack1, itemstack);
                } else if (index >= 19 ? (this.te.hasRecipe(itemstack1) ? (this.getTier() == 2 ? !this.moveItemStackTo(itemstack1, 7, 13, false) : (this.getTier() == 1 ? !this.moveItemStackTo(itemstack1, 8, 12, false) : !this.moveItemStackTo(itemstack1, 9, 11, false))) : (BlockIronFurnaceTileBase.isItemAugment(itemstack1, 0) ? !this.moveItemStackTo(itemstack1, 3, 4, false) : (BlockIronFurnaceTileBase.isItemAugment(itemstack1, 1) ? !this.moveItemStackTo(itemstack1, 4, 5, false) : (BlockIronFurnaceTileBase.isItemAugment(itemstack1, 2) ? !this.moveItemStackTo(itemstack1, 5, 6, false) : (index >= 19 && index <= 45 ? !this.moveItemStackTo(itemstack1, 46, 55, false) : index >= 45 && index < 55 && !this.moveItemStackTo(itemstack1, 19, 46, false)))))) : !this.moveItemStackTo(itemstack1, 19, 55, false)) {
                    return ItemStack.EMPTY;
                }
            }
            if (this.te.isFurnace()) {
                if (index == 2) {
                    if (!this.moveItemStackTo(itemstack1, 19, 55, true)) {
                        return ItemStack.EMPTY;
                    }
                    slot.onQuickCraft(itemstack1, itemstack);
                } else if (index != 1 && index != 0 && index != 3 && index != 4 && index != 5 ? (this.te.hasRecipe(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (BlockIronFurnaceTileBase.isItemFuel(itemstack1, RecipeType.SMELTING) ? !this.moveItemStackTo(itemstack1, 1, 2, false) : (BlockIronFurnaceTileBase.isItemAugment(itemstack1, 0) ? !this.moveItemStackTo(itemstack1, 3, 4, false) : (BlockIronFurnaceTileBase.isItemAugment(itemstack1, 1) ? !this.moveItemStackTo(itemstack1, 4, 5, false) : (BlockIronFurnaceTileBase.isItemAugment(itemstack1, 2) ? !this.moveItemStackTo(itemstack1, 5, 6, false) : (index >= 19 && index <= 45 ? !this.moveItemStackTo(itemstack1, 46, 55, false) : index >= 45 && index < 55 && !this.moveItemStackTo(itemstack1, 19, 46, false))))))) : !this.moveItemStackTo(itemstack1, 19, 55, false)) {
                    return ItemStack.EMPTY;
                }
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    private boolean specialMoveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        int l;
        ItemStack itemstack;
        Slot slot1;
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot1 = (Slot)this.slots.get(i);
                itemstack = slot1.getItem();
                if (!itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack)) {
                    int k;
                    l = itemstack.getCount() + stack.getCount();
                    if (l <= (k = slot1.getMaxStackSize(itemstack))) {
                        stack.setCount(0);
                        itemstack.setCount(l);
                        slot1.setChanged();
                        flag = true;
                    } else if (itemstack.getCount() < k) {
                        stack.shrink(k - itemstack.getCount());
                        itemstack.setCount(k);
                        slot1.setChanged();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot1 = (Slot)this.slots.get(i);
                itemstack = slot1.getItem();
                if (itemstack.isEmpty() && slot1.mayPlace(stack)) {
                    l = slot1.getMaxStackSize(stack);
                    slot1.setByPlayer(stack.split(Math.min(1, l)));
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }
}

