/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.item;

import alabaster.crabbersdelight.common.registry.CDArmorMaterials;
import alabaster.crabbersdelight.common.registry.CDModItems;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PearlNecklaceItem
extends ArmorItem {
    private static final int TICK_INTERVAL = 100;
    private static final int EFFECT_DURATION = 10;

    public PearlNecklaceItem(Item.Properties properties) {
        super(Holder.direct((Object)CDArmorMaterials.PEARL_NECKLACE), ArmorItem.Type.CHESTPLATE, properties.durability(128));
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.CHEST;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repairCandidate) {
        return repairCandidate.is(CDModItems.PEARL.get());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return this.swapWithEquipmentSlot((Item)this, level, player, hand);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (world.isClientSide) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.getItemBySlot(EquipmentSlot.CHEST) != stack) {
            return;
        }
        if (player.isInWaterRainOrBubble()) {
            player.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 10, 0, false, false, true));
            player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 10, 0, false, false, true));
            if (world.getGameTime() % 100L == 0L) {
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.CHEST);
            }
        }
    }
}

