/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.entity.crab;

import alabaster.crabbersdelight.common.entity.crab.CrabVariant;
import alabaster.crabbersdelight.common.registry.CDModEntities;
import alabaster.crabbersdelight.common.registry.CDModItems;
import alabaster.crabbersdelight.common.tags.CDModTags;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class CrabEntity
extends Animal
implements Bucketable {
    private static EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private Ingredient temptationItems;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public CrabEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 0.75, (Predicate)this.getTemptationItems(), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.ATTACK_KNOCKBACK, 1.5).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 1.0);
    }

    public int getMaxAirSupply() {
        return 100;
    }

    protected void handleAirSupply(int airSupply) {
        this.setAirSupply(this.getMaxAirSupply());
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        if (!this.isNoAi()) {
            this.handleAirSupply(i);
        }
    }

    protected boolean isAffectedByFluids() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @javax.annotation.Nullable SpawnGroupData spawnGroupData) {
        Holder holder = level.getBiome(this.blockPosition());
        if (holder.is(Biomes.MANGROVE_SWAMP)) {
            this.setVariant(CrabVariant.BLUE);
        } else if (holder.is(Biomes.BEACH)) {
            this.setVariant(CrabVariant.RED);
        } else if (holder.is(Biomes.SWAMP)) {
            this.setVariant(CrabVariant.GREEN);
        } else if (holder.is(Biomes.STONY_SHORE)) {
            this.setVariant(CrabVariant.LIGHT_GRAY);
        } else if (holder.is(Biomes.SNOWY_BEACH)) {
            this.setVariant(CrabVariant.WHITE);
        } else {
            this.setVariant(CrabVariant.BLUE);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public static boolean checkCrabSpawnRules(EntityType<CrabEntity> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        BlockState stateBelow = level.getBlockState(pos.below());
        return stateBelow.is(CDModTags.CRAB_SPAWN_ON);
    }

    public static boolean canCrabSpawn(EntityType<CrabEntity> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(CDModTags.CRAB_SPAWN_ON);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
        builder.define(FROM_BUCKET, (Object)false);
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public CrabVariant getVariant() {
        return CrabVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(CrabVariant variant) {
        this.entityData.set(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getTypeVariant());
        compound.putBoolean("FromBucket", this.fromBucket());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(VARIANT, (Object)compound.getInt("Variant"));
        this.entityData.set(FROM_BUCKET, (Object)compound.getBoolean("FromBucket"));
    }

    @Nullable
    public CrabEntity getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        CrabEntity baby = (CrabEntity)CDModEntities.CRAB.get().create((Level)level);
        if (!(otherParent instanceof CrabEntity)) {
            return baby;
        }
        CrabEntity otherCrab = (CrabEntity)otherParent;
        DyeColor color1 = this.getVariant().getDyeColor();
        DyeColor color2 = otherCrab.getVariant().getDyeColor();
        DyeColor mixedColor = CrabEntity.getMixedDyeColor(level, color1, color2);
        baby.setVariant(CrabVariant.fromDyeColor(mixedColor != null ? mixedColor : color1));
        return baby;
    }

    @Nullable
    private static DyeColor getMixedDyeColor(ServerLevel level, DyeColor color1, DyeColor color2) {
        if (color1 == color2) {
            return color1;
        }
        RecipeManager recipeManager = level.getRecipeManager();
        for (RecipeHolder holder : recipeManager.getAllRecipesFor(RecipeType.CRAFTING)) {
            List<DyeColor> inputColors;
            ShapelessRecipe shapeless;
            Item item;
            CraftingRecipe recipe = (CraftingRecipe)holder.value();
            if (!(recipe instanceof ShapelessRecipe) || !((item = (shapeless = (ShapelessRecipe)recipe).getResultItem((HolderLookup.Provider)level.registryAccess()).getItem()) instanceof DyeItem)) continue;
            DyeItem resultDye = (DyeItem)item;
            if (shapeless.getIngredients().size() != 2 || (inputColors = shapeless.getIngredients().stream().map(ingredient -> {
                Item patt0$temp;
                ItemStack[] stacks = ingredient.getItems();
                if (stacks.length > 0 && (patt0$temp = stacks[0].getItem()) instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)patt0$temp;
                    return dyeItem.getDyeColor();
                }
                return null;
            }).filter(c -> c != null).toList()).size() != 2 || (inputColors.get(0) != color1 || inputColors.get(1) != color2) && (inputColors.get(0) != color2 || inputColors.get(1) != color1)) continue;
            return resultDye.getDyeColor();
        }
        return null;
    }

    private Ingredient getTemptationItems() {
        if (this.temptationItems == null) {
            this.temptationItems = Ingredient.of(CDModTags.CRAB_TEMPT_ITEM);
        }
        return this.temptationItems;
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean fromBucket) {
        this.entityData.set(FROM_BUCKET, (Object)true);
    }

    public boolean isFood(ItemStack stack) {
        return !stack.isEmpty() && this.getTemptationItems().test(stack);
    }

    public void saveToBucketTag(@Nonnull ItemStack stack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, tag -> {
            tag.putInt("Age", this.getAge());
            tag.putInt("Variant", this.getTypeVariant());
        });
    }

    public void loadFromBucketTag(@Nonnull CompoundTag tag) {
        int i;
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)tag);
        if (tag.contains("Age")) {
            this.setAge(tag.getInt("Age"));
        }
        if ((i = tag.getInt("Variant")) >= 0 && i < this.getTypeVariant()) {
            this.setVariant(this.getVariant());
        }
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)CDModItems.CRAB_BUCKET.get());
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_AXOLOTL;
    }

    public InteractionResult mobInteract(@Nonnull Player player, @Nonnull InteractionHand hand) {
        DyeItem dyeItem;
        DyeColor dyeColor;
        CrabVariant newVariant;
        Optional result = Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this);
        if (result.isPresent()) {
            return (InteractionResult)result.get();
        }
        ItemStack itemStack = player.getItemInHand(hand);
        Item item = itemStack.getItem();
        if (item instanceof DyeItem && (newVariant = CrabVariant.fromDyeColor(dyeColor = (dyeItem = (DyeItem)item).getDyeColor())) != this.getVariant()) {
            this.setVariant(newVariant);
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 60;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }
}

