/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.create_better_motors.content.alternator.blocksentity;

import com.mrh0.createaddition.energy.IEnergyProvider;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.reggarf.mods.create_better_motors.config.CommonConfig;
import com.reggarf.mods.create_better_motors.registry.CBMBlockEntityTypes;
import com.reggarf.mods.create_better_motors.registry.CBMBlocks;
import com.reggarf.mods.create_better_motors.util.StringFormattingTool;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class BrassAlternatorBlockEntity
extends KineticBlockEntity
implements IEnergyProvider {
    private final InternalEnergyStorage energy;
    private final IEnergyStorage capability;
    private final EnumMap<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> cache = new EnumMap(Direction.class);
    private final EnumSet<Direction> invalidSides = EnumSet.noneOf(Direction.class);
    private boolean firstTickDone = false;

    public BrassAlternatorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.energy = new InternalEnergyStorage(((Integer)CommonConfig.BRASS_ALTERNATOR.CAPACITY.get()).intValue(), 0, ((Integer)CommonConfig.BRASS_ALTERNATOR.MAX_OUTPUT.get()).intValue());
        this.capability = this.energy;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)CBMBlockEntityTypes.BRASS_ALTERNATOR.get(), (be, context) -> be.capability);
    }

    public void tick() {
        super.tick();
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        if (!this.firstTickDone) {
            this.firstTickDone = true;
            this.updateCache();
        }
        if (Math.abs(this.getSpeed()) > 0.0f && this.isSpeedRequirementFulfilled()) {
            int production = BrassAlternatorBlockEntity.getEnergyProductionRate((int)this.getSpeed());
            this.energy.internalProduceEnergy(production);
        }
        this.distributeEnergy();
    }

    private void distributeEnergy() {
        for (Direction d : Direction.values()) {
            IEnergyStorage target;
            BlockCapabilityCache<IEnergyStorage, Direction> cached;
            if (!this.isEnergyOutput(d) || (cached = this.cache.get(d)) == null || (target = (IEnergyStorage)cached.getCapability()) == null) continue;
            int toSend = this.energy.extractEnergy(target.receiveEnergy(((Integer)CommonConfig.BRASS_ALTERNATOR.MAX_OUTPUT.get()).intValue(), true), false);
            target.receiveEnergy(toSend, false);
        }
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)((Integer)CommonConfig.BRASS_ALTERNATOR.MAX_STRESS.get()).intValue() / 256.0f;
        return impact;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"tooltip.create_better_motors.generating", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_better_motors.energy_output", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_better_motors.energy_per_tick", (Object[])new Object[]{StringFormattingTool.formatLong(BrassAlternatorBlockEntity.getEnergyProductionRate((int)this.getSpeed()))}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        CreateLang.translate((String)"tooltip.create_better_motors.energy_stored", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_better_motors.energy_storage", (Object[])new Object[]{StringFormattingTool.formatLong(this.energy.getEnergyStored()), StringFormattingTool.formatLong(this.energy.getMaxEnergyStored())}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        return true;
    }

    public boolean isEnergyOutput(Direction side) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        float componentSpeed = Math.abs(this.getSpeed());
        if (componentSpeed == 0.0f || !this.isSpeedRequirementFulfilled()) {
            return;
        }
        if (((Boolean)CommonConfig.BRASS_ALTERNATOR.AUDIO_ENABLED.get()).booleanValue()) {
            float pitch = Mth.clamp((float)(componentSpeed / 256.0f + 0.5f), (float)0.5f, (float)1.5f);
            CASoundScapes.play((CASoundScapes.AmbienceGroup)CASoundScapes.AmbienceGroup.DYNAMO, (BlockPos)this.worldPosition, (float)pitch);
        }
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.energy.read(tag);
    }

    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        this.energy.write(tag);
    }

    public void updateCache() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        for (Direction side : Direction.values()) {
            this.cache.put(side, (BlockCapabilityCache<IEnergyStorage, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.getBlockPos().relative(side), (Object)side.getOpposite(), () -> !this.isRemoved(), () -> this.invalidSides.add(side)));
        }
    }

    public static int getEnergyProductionRate(int rpm) {
        rpm = Math.abs(rpm);
        return (int)((double)((Integer)CommonConfig.BRASS_ALTERNATOR.FE_RPM.get()).intValue() * ((double)rpm / 256.0) * (Double)CommonConfig.BRASS_ALTERNATOR.EFFICIENCY.get());
    }

    protected Block getStressConfigKey() {
        return (Block)CBMBlocks.BRASS_ALTERNATOR.get();
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.energy;
    }
}

