/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train.portable;

import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.portable.BasicTrainDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainStopDisplayData;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class StationDisplayData {
    private final BasicTrainDisplayData trainData;
    private final TrainStopDisplayData stationData;
    private final String firstStopName;
    private final boolean isFirstStop;
    private final boolean isLastStop;
    private final boolean showArrival;
    private final boolean isNextSectionExcluded;
    private final List<String> stopovers;
    private static final String NBT_TRAIN = "Train";
    private static final String NBT_STATION = "Station";
    private static final String NBT_STOPOVERS = "Stopovers";
    private static final String NBT_FIRST_STOP = "FirstStop";
    private static final String NBT_IS_FIRST = "IsFirst";
    private static final String NBT_IS_LAST = "IsLast";
    private static final String NBT_SHOW_ARRIVAL = "ShowArrival";
    private static final String NBT_IS_NEXT_EXCLUDED = "IsNextSectionExcluded";

    public StationDisplayData(BasicTrainDisplayData trainData, TrainStopDisplayData stationData, String firstStopName, boolean isFirstStop, boolean isLastStop, boolean showArrival, boolean isNextSectionExcluded, List<String> stopovers) {
        this.trainData = trainData;
        this.stationData = stationData;
        this.stopovers = stopovers;
        this.firstStopName = firstStopName;
        this.isFirstStop = isFirstStop;
        this.isLastStop = isLastStop;
        this.showArrival = showArrival;
        this.isNextSectionExcluded = isNextSectionExcluded;
    }

    public static StationDisplayData empty() {
        return new StationDisplayData(BasicTrainDisplayData.empty(), TrainStopDisplayData.empty(), "", false, false, false, false, List.of());
    }

    public static StationDisplayData of(TrainStop stop) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        return TrainListener.getTrainData(stop.getTrainId()).map(data -> {
            ScheduleSection section = data.getSectionByIndex(stop.getSectionIndex());
            ScheduleSection previousSection = section.previousSection();
            boolean isFirstStopOfSection = section.getFirstStop().isPresent() && section.getFirstStop().get().getEntryIndex() == stop.getScheduleIndex();
            ScheduleSection targetedSection = section;
            boolean isLastStopOfSection = false;
            if (section.getFinalStop().isPresent()) {
                if (isFirstStopOfSection && previousSection.shouldIncludeNextStationOfNextSection() && previousSection.getFinalStop().isPresent()) {
                    targetedSection = previousSection;
                }
                isLastStopOfSection = targetedSection.getFinalStop().get().getEntryIndex() == stop.getScheduleIndex();
            }
            boolean showArrival = false;
            if (isLastStopOfSection && section.isUsable()) {
                if (!section.nextSection().isUsable()) {
                    showArrival = true;
                } else if (!isFirstStopOfSection) {
                    showArrival = true;
                } else if (data.waitingAtStationIndex != stop.getScheduleIndex()) {
                    showArrival = true;
                }
            }
            ScheduleSection sectionForOrigin = section;
            if (isFirstStopOfSection) {
                sectionForOrigin = previousSection;
            }
            String firstStop = sectionForOrigin.getFirstStop().isPresent() ? sectionForOrigin.getFirstStop().get().getStationTag().getTagName().get() : "?";
            return new StationDisplayData(BasicTrainDisplayData.of(stop), TrainStopDisplayData.of(stop), firstStop, isFirstStopOfSection, isLastStopOfSection, showArrival, isLastStopOfSection && (!targetedSection.nextSection().isUsable() || !targetedSection.shouldIncludeNextStationOfNextSection()), section.getStopoversFrom(stop.getScheduleIndex()));
        }).orElse(StationDisplayData.empty());
    }

    public BasicTrainDisplayData getTrainData() {
        return this.trainData;
    }

    public TrainStopDisplayData getStationData() {
        return this.stationData;
    }

    public List<String> getStopovers() {
        return this.stopovers;
    }

    public String getFirstStopName() {
        return this.firstStopName;
    }

    public boolean isFirstStop() {
        return this.isFirstStop;
    }

    public boolean isLastStop() {
        return this.isLastStop;
    }

    public boolean shouldShowArrivalOfTrain() {
        return this.showArrival;
    }

    public boolean isNextSectionExcluded() {
        return this.isNextSectionExcluded;
    }

    public boolean isDelayed() {
        return this.isLastStop() ? this.getStationData().isArrivalDelayed() : this.getStationData().isDepartureDelayed();
    }

    public long getScheduledTime() {
        return this.isLastStop() ? this.getStationData().getScheduledArrivalTime() : this.getStationData().getScheduledDepartureTime();
    }

    public long getRealTime() {
        return this.isLastStop() ? this.getStationData().getRealTimeArrivalTime() : this.getStationData().getRealTimeDepartureTime();
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag stopoversList = new ListTag();
        List<String> stations = this.getStopovers();
        for (String name : stations) {
            stopoversList.add((Object)StringTag.valueOf((String)name));
        }
        nbt.put(NBT_TRAIN, (Tag)this.trainData.toNbt());
        nbt.put(NBT_STATION, (Tag)this.stationData.toNbt());
        nbt.putString(NBT_FIRST_STOP, this.firstStopName);
        nbt.putBoolean(NBT_IS_FIRST, this.isFirstStop);
        nbt.putBoolean(NBT_IS_LAST, this.isLastStop);
        nbt.putBoolean(NBT_SHOW_ARRIVAL, this.showArrival);
        nbt.putBoolean(NBT_IS_NEXT_EXCLUDED, this.isNextSectionExcluded);
        nbt.put(NBT_STOPOVERS, (Tag)stopoversList);
        return nbt;
    }

    public static StationDisplayData fromNbt(CompoundTag nbt) {
        return new StationDisplayData(BasicTrainDisplayData.fromNbt(nbt.getCompound(NBT_TRAIN)), TrainStopDisplayData.fromNbt(nbt.getCompound(NBT_STATION)), nbt.getString(NBT_FIRST_STOP), nbt.getBoolean(NBT_IS_FIRST), nbt.getBoolean(NBT_IS_LAST), nbt.getBoolean(NBT_SHOW_ARRIVAL), nbt.getBoolean(NBT_IS_NEXT_EXCLUDED), nbt.getList(NBT_STOPOVERS, 8).stream().map(x -> ((StringTag)x).getAsString()).toList());
    }

    public final boolean equals(Object obj) {
        StationDisplayData o;
        return obj instanceof StationDisplayData && (o = (StationDisplayData)obj).getTrainData().equals(this.getTrainData()) && o.getStationData().equals(this.getStationData());
    }

    public final int hashCode() {
        return Objects.hash(this.getTrainData(), this.getStationData());
    }
}

