/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.IShowDoNotBoardText;
import de.mrjulsen.crn.block.display.properties.components.IShowLineColorSetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainNameWidthSetting;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import net.minecraft.nbt.CompoundTag;

public class TrainDestinationCompactSettings
extends BasicDisplaySettings
implements ITrainNameWidthSetting,
IShowLineColorSetting,
IShowDoNotBoardText {
    protected byte trainNameWidth = (byte)-1;
    protected boolean showLineColor = false;
    protected boolean showDoNotBoardText = true;

    @Override
    public void deserializeNbt(CompoundTag nbt) {
        super.deserializeNbt(nbt);
        if (nbt.contains("TrainNameWidth")) {
            this.trainNameWidth = nbt.getByte("TrainNameWidth");
        }
        if (nbt.contains("ShowLineColor")) {
            this.showLineColor = nbt.getBoolean("ShowLineColor");
        }
        if (nbt.contains("ShowDoNotBoardText")) {
            this.showDoNotBoardText = nbt.getBoolean("ShowDoNotBoardText");
        }
    }

    @Override
    public void serializeNbt(CompoundTag nbt) {
        super.serializeNbt(nbt);
        nbt.putByte("TrainNameWidth", this.trainNameWidth);
        nbt.putBoolean("ShowLineColor", this.showLineColor);
        nbt.putBoolean("ShowDoNotBoardText", this.showDoNotBoardText);
    }

    @Override
    public void buildGui(GuiBuilderContext context) {
        super.buildGui(context);
        this.buildTrainNameGui(context, true, true);
        this.buildShowLineColorGui(context);
        this.buildShowDoNotBoardTextGui(context);
    }

    @Override
    public void onChangeSettings(IDisplaySettings oldSettings) {
        super.onChangeSettings(oldSettings);
        this.copyTrainNameSetting(oldSettings);
        this.copyShowLineColorSetting(oldSettings);
        this.copyShowDoNotBoardTextSetting(oldSettings);
    }

    @Override
    public byte getTrainNameWidth() {
        return this.trainNameWidth;
    }

    @Override
    public void setTrainNameWidth(byte b) {
        this.trainNameWidth = b;
    }

    @Override
    public boolean showLineColor() {
        return this.showLineColor;
    }

    @Override
    public void setShowLineColor(boolean b) {
        this.showLineColor = b;
    }

    @Override
    public boolean showDoNotBoardText() {
        return this.showDoNotBoardText;
    }

    @Override
    public void setShowDoNotBoardText(boolean b) {
        this.showDoNotBoardText = b;
    }
}

