/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;

public interface Modifier {
    public static final Codec<Modifier> CODEC = Codec.lazyInitialized(() -> {
        Optional modifierRegistry = BuiltInRegistries.REGISTRY.getOptional(LithostitchedRegistryKeys.MODIFIER_TYPE.location());
        if (modifierRegistry.isEmpty()) {
            throw new NullPointerException("Worldgen modifier registry does not exist yet!");
        }
        return ((Registry)modifierRegistry.get()).byNameCodec();
    }).dispatch(Modifier::codec, Function.identity());
    public static final MapCodec<Integer> PRIORITY_DEFAULT = Codec.INT.optionalFieldOf("priority", (Object)1000);
    public static final MapCodec<Integer> PRIORITY_REMOVE = Codec.INT.optionalFieldOf("priority", (Object)2000);

    default public void applyModifier(RegistryAccess registryAccess) {
        this.applyModifier();
    }

    public void applyModifier();

    public int priority();

    public MapCodec<? extends Modifier> codec();

    default public boolean internal$modifiesFabricFeatures() {
        return false;
    }
}

