/*
 * Decompiled with CFR 0.152.
 */
package com.baisylia.culturaldelights.block;

import com.baisylia.culturaldelights.block.custom.AvocadoPitBlock;
import com.baisylia.culturaldelights.block.custom.CornBlock;
import com.baisylia.culturaldelights.block.custom.CornUpperBlock;
import com.baisylia.culturaldelights.block.custom.CucumbersBlock;
import com.baisylia.culturaldelights.block.custom.EggplantFeastBlock;
import com.baisylia.culturaldelights.block.custom.EggplantsBlock;
import com.baisylia.culturaldelights.block.custom.ExoticRollMedleyBlock;
import com.baisylia.culturaldelights.block.custom.FruitingLeaves;
import com.baisylia.culturaldelights.block.custom.ModFlammableRotatedPillarBlock;
import com.baisylia.culturaldelights.item.ModItems;
import com.baisylia.culturaldelights.world.tree.ModTreeGrowers;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import vectorwing.farmersdelight.common.block.WildCropBlock;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"culturaldelights");
    public static final DeferredBlock<Block> WILD_CUCUMBERS = ModBlocks.registerBlock("wild_cucumbers", () -> new WildCropBlock(MobEffects.FIRE_RESISTANCE, 6, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS)));
    public static final DeferredBlock<Block> WILD_CORN = ModBlocks.registerBlock("wild_corn", () -> new WildCropBlock(MobEffects.HUNGER, 6, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS)));
    public static final DeferredBlock<Block> WILD_EGGPLANTS = ModBlocks.registerBlock("wild_eggplants", () -> new WildCropBlock(MobEffects.DAMAGE_BOOST, 6, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS)));
    public static final DeferredBlock<Block> AVOCADO_PIT = ModBlocks.registerBlock("avocado_pit", () -> new AvocadoPitBlock(ModTreeGrowers.AVOCADO, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    public static final DeferredBlock<Block> AVOCADO_SAPLING = ModBlocks.registerBlock("avocado_sapling", () -> new SaplingBlock(ModTreeGrowers.AVOCADO, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    public static final DeferredBlock<Block> AVOCADO_LOG = ModBlocks.registerBlock("avocado_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JUNGLE_LOG)));
    public static final DeferredBlock<Block> AVOCADO_WOOD = ModBlocks.registerBlock("avocado_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JUNGLE_WOOD)));
    public static final DeferredBlock<Block> AVOCADO_LEAVES = ModBlocks.registerBlock("avocado_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JUNGLE_LEAVES)){

        public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
            return 60;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
            return 30;
        }
    });
    public static final DeferredBlock<Block> FRUITING_AVOCADO_LEAVES = ModBlocks.registerBlock("fruiting_avocado_leaves", () -> new FruitingLeaves(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JUNGLE_LEAVES)){

        public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
            return 60;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
            return 30;
        }
    });
    public static final DeferredBlock<Block> CUCUMBERS = BLOCKS.register("cucumbers", () -> new CucumbersBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT).noOcclusion()));
    public static final DeferredBlock<Block> EGGPLANTS = BLOCKS.register("eggplants", () -> new EggplantsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT).noOcclusion()));
    public static final DeferredBlock<Block> CORN = BLOCKS.register("corn", () -> new CornBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT).noOcclusion()));
    public static final DeferredBlock<Block> CORN_UPPER = BLOCKS.register("corn_upper", () -> new CornUpperBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT).noOcclusion()));
    public static final DeferredBlock<Block> AVOCADO_CRATE = ModBlocks.registerBlock("avocado_crate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)vectorwing.farmersdelight.common.registry.ModBlocks.CARROT_CRATE.get()))));
    public static final DeferredBlock<Block> CUCUMBER_CRATE = ModBlocks.registerBlock("cucumber_crate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)vectorwing.farmersdelight.common.registry.ModBlocks.CARROT_CRATE.get()))));
    public static final DeferredBlock<Block> PICKLE_CRATE = ModBlocks.registerBlock("pickle_crate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)vectorwing.farmersdelight.common.registry.ModBlocks.CARROT_CRATE.get()))));
    public static final DeferredBlock<Block> CORN_COB_CRATE = ModBlocks.registerBlock("corn_cob_crate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)vectorwing.farmersdelight.common.registry.ModBlocks.CARROT_CRATE.get()))));
    public static final DeferredBlock<Block> EGGPLANT_CRATE = ModBlocks.registerBlock("eggplant_crate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)vectorwing.farmersdelight.common.registry.ModBlocks.CARROT_CRATE.get()))));
    public static final DeferredBlock<Block> WHITE_EGGPLANT_CRATE = ModBlocks.registerBlock("white_eggplant_crate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)vectorwing.farmersdelight.common.registry.ModBlocks.CARROT_CRATE.get()))));
    public static final DeferredBlock<Block> EXOTIC_ROLL_MEDLEY = ModBlocks.registerBlock("exotic_roll_medley", () -> new ExoticRollMedleyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)vectorwing.farmersdelight.common.registry.ModBlocks.RICE_ROLL_MEDLEY_BLOCK.get())).noOcclusion()));
    public static final DeferredBlock<Block> EGGPLANT_PARMESAN_BLOCK = ModBlocks.registerBlock("eggplant_parmesan_block", () -> new EggplantFeastBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)vectorwing.farmersdelight.common.registry.ModBlocks.ROAST_CHICKEN_BLOCK.get())), (Supplier<Item>)ModItems.EGGPLANT_PARMESAN, true));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

