/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.features;

import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.blocks.vegetation.SculkTendrilsBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.SculkTendrilsPlantBlock;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SculkTendrilsFeature
extends Feature<NoneFeatureConfiguration> {
    public SculkTendrilsFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos origin;
        WorldGenLevel level = context.level();
        if (this.isValidPlacementLocation((LevelAccessor)level, origin = context.origin())) {
            RandomSource random = context.random();
            int width = 8;
            int height = 4;
            int maxHeight = 8;
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            for (int i = 0; i < width * width; ++i) {
                blockPos.set((Vec3i)origin).move(Mth.nextInt((RandomSource)random, (int)(-width), (int)width), Mth.nextInt((RandomSource)random, (int)(-height), (int)height), Mth.nextInt((RandomSource)random, (int)(-width), (int)width));
                if (!this.findAirAboveGround((LevelAccessor)level, blockPos) || !this.isValidPlacementLocation((LevelAccessor)level, (BlockPos)blockPos)) continue;
                int length = Mth.nextInt((RandomSource)random, (int)1, (int)maxHeight);
                if (random.nextInt(6) == 0) {
                    length *= 2;
                }
                if (random.nextInt(5) == 0) {
                    length = 1;
                }
                this.placeColumn((LevelAccessor)level, random, blockPos, length);
            }
            return true;
        }
        return false;
    }

    private boolean isValidPlacementLocation(LevelAccessor level, BlockPos pos) {
        return level.getBlockState(pos.below()).is(Blocks.SCULK);
    }

    private boolean findAirAboveGround(LevelAccessor level, BlockPos.MutableBlockPos pos) {
        do {
            pos.move(0, -1, 0);
            if (!level.isOutsideBuildHeight((BlockPos)pos)) continue;
            return false;
        } while (level.getBlockState((BlockPos)pos).isAir());
        pos.move(0, 1, 0);
        return true;
    }

    private void placeColumn(LevelAccessor level, RandomSource random, BlockPos.MutableBlockPos pos, int length) {
        for (int i = 1; i <= length; ++i) {
            if (level.isEmptyBlock((BlockPos)pos)) {
                if (i == length || !level.isEmptyBlock(pos.above())) {
                    level.setBlock((BlockPos)pos, (BlockState)((SculkTendrilsBlock)((Object)DDBlocks.SCULK_TENDRILS.get())).defaultBlockState().setValue((Property)GrowingPlantHeadBlock.AGE, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)random, (int)17, (int)25))), 3);
                    break;
                }
                level.setBlock((BlockPos)pos, ((SculkTendrilsPlantBlock)((Object)DDBlocks.SCULK_TENDRILS_PLANT.get())).defaultBlockState(), 3);
            }
            pos.move(Direction.UP);
        }
    }
}

